/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.parser;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.seata.common.Constants;
import io.seata.common.loader.LoadLevel;
import io.seata.rm.datasource.undo.BranchUndoLog;
import io.seata.rm.datasource.undo.UndoLogParser;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="jackson")
public class JacksonUndoLogParser
implements UndoLogParser {
    public static final String NAME = "jackson";
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonUndoLogParser.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final SimpleModule MODULE = new SimpleModule();
    private static final JsonSerializer TIMESTAMP_SERIALIZER = new TimestampSerializer();
    private static final JsonDeserializer TIMESTAMP_DESERIALIZER = new TimestampDeserializer();
    private static final JsonSerializer BLOB_SERIALIZER = new BlobSerializer();
    private static final JsonDeserializer BLOB_DESERIALIZER = new BlobDeserializer();
    private static final JsonSerializer CLOB_SERIALIZER = new ClobSerializer();
    private static final JsonDeserializer CLOB_DESERIALIZER = new ClobDeserializer();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        return "{}".getBytes(Constants.DEFAULT_CHARSET);
    }

    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        try {
            byte[] bytes = MAPPER.writeValueAsBytes((Object)branchUndoLog);
            return bytes;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("json encode exception, {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public BranchUndoLog decode(byte[] bytes) {
        try {
            BranchUndoLog branchUndoLog = (BranchUndoLog)MAPPER.readValue(bytes, BranchUndoLog.class);
            return branchUndoLog;
        }
        catch (IOException e) {
            LOGGER.error("json decode exception, {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    static {
        MODULE.addSerializer(Timestamp.class, TIMESTAMP_SERIALIZER);
        MODULE.addDeserializer(Timestamp.class, TIMESTAMP_DESERIALIZER);
        MODULE.addSerializer(SerialBlob.class, BLOB_SERIALIZER);
        MODULE.addDeserializer(SerialBlob.class, BLOB_DESERIALIZER);
        MODULE.addSerializer(SerialClob.class, CLOB_SERIALIZER);
        MODULE.addDeserializer(SerialClob.class, CLOB_DESERIALIZER);
        MAPPER.registerModule((Module)MODULE);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        MAPPER.enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER});
    }

    private static class ClobDeserializer
    extends JsonDeserializer<SerialClob> {
        private ClobDeserializer() {
        }

        public SerialClob deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return new SerialClob(p.getValueAsString().toCharArray());
            }
            catch (SQLException e) {
                LOGGER.error("deserialize java.sql.Clob error : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    private static class ClobSerializer
    extends JsonSerializer<SerialClob> {
        private ClobSerializer() {
        }

        public void serializeWithType(SerialClob clob, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)clob, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(clob, gen, serializers);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        public void serialize(SerialClob clob, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            try {
                gen.writeString(clob.getCharacterStream(), (int)clob.length());
            }
            catch (SerialException e) {
                LOGGER.error("serialize java.sql.Blob error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static class BlobDeserializer
    extends JsonDeserializer<SerialBlob> {
        private BlobDeserializer() {
        }

        public SerialBlob deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return new SerialBlob(p.getBinaryValue());
            }
            catch (SQLException e) {
                LOGGER.error("deserialize java.sql.Blob error : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    private static class BlobSerializer
    extends JsonSerializer<SerialBlob> {
        private BlobSerializer() {
        }

        public void serializeWithType(SerialBlob blob, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)blob, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(blob, gen, serializers);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        public void serialize(SerialBlob blob, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            try {
                gen.writeBinary(blob.getBytes(1L, (int)blob.length()));
            }
            catch (SerialException e) {
                LOGGER.error("serialize java.sql.Blob error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static class TimestampDeserializer
    extends JsonDeserializer<Timestamp> {
        private TimestampDeserializer() {
        }

        public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) {
            if (p.isExpectedStartArrayToken()) {
                try {
                    ArrayNode arrayNode = (ArrayNode)p.getCodec().readTree(p);
                    Timestamp timestamp = new Timestamp(arrayNode.get(0).asLong());
                    timestamp.setNanos(arrayNode.get(1).asInt());
                    return timestamp;
                }
                catch (IOException e) {
                    LOGGER.error("deserialize java.sql.Timestamp error : {}", (Object)e.getMessage(), (Object)e);
                }
            }
            LOGGER.error("deserialize java.sql.Timestamp type error.");
            return null;
        }
    }

    private static class TimestampSerializer
    extends JsonSerializer<Timestamp> {
        private TimestampSerializer() {
        }

        public void serializeWithType(Timestamp timestamp, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
            WritableTypeId typeId = typeSerializer.writeTypePrefix(gen, typeSerializer.typeId((Object)timestamp, JsonToken.START_ARRAY));
            this.serialize(timestamp, gen, serializers);
            gen.writeTypeSuffix(typeId);
        }

        public void serialize(Timestamp timestamp, JsonGenerator gen, SerializerProvider serializers) {
            try {
                gen.writeNumber(timestamp.getTime());
                gen.writeNumber(timestamp.getNanos());
            }
            catch (IOException e) {
                LOGGER.error("serialize java.sql.Timestamp error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

