/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.seata.protocol;

import io.netty.buffer.ByteBuf;
import io.seata.codec.seata.protocol.AbstractMessageCodec;
import io.seata.core.protocol.AbstractResultMessage;
import io.seata.core.protocol.ResultCode;
import java.nio.ByteBuffer;

public abstract class AbstractResultMessageCodec
extends AbstractMessageCodec {
    @Override
    public Class<?> getMessageClassType() {
        return AbstractResultMessage.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        AbstractResultMessage abstractResultMessage = (AbstractResultMessage)t;
        ResultCode resultCode = abstractResultMessage.getResultCode();
        String resultMsg = abstractResultMessage.getMsg();
        out.writeByte(resultCode.ordinal());
        if (resultCode == ResultCode.Failed) {
            if (resultMsg != null) {
                String msg = resultMsg.length() > 128 ? resultMsg.substring(0, 128) : resultMsg;
                byte[] bs = msg.getBytes(UTF8);
                if (bs.length > 400 && resultMsg.length() > 64) {
                    msg = resultMsg.substring(0, 64);
                    bs = msg.getBytes(UTF8);
                }
                out.writeShort((int)((short)bs.length));
                if (bs.length > 0) {
                    out.writeBytes(bs);
                }
            } else {
                out.writeShort(0);
            }
        }
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        short len;
        AbstractResultMessage abstractResultMessage = (AbstractResultMessage)t;
        ResultCode resultCode = ResultCode.get(in.get());
        abstractResultMessage.setResultCode(resultCode);
        if (resultCode == ResultCode.Failed && (len = in.getShort()) > 0) {
            byte[] msg = new byte[len];
            in.get(msg);
            abstractResultMessage.setMsg(new String(msg, UTF8));
        }
    }
}

