/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport.netty.websocket;

import io.netty.channel.ChannelOption;
import io.scalecube.cluster.transport.api.TransportConfig;
import io.scalecube.transport.netty.Receiver;
import io.scalecube.transport.netty.TransportImpl;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public final class WebsocketReceiver
implements Receiver {
    private final TransportConfig config;

    public WebsocketReceiver(TransportConfig config) {
        this.config = config;
    }

    @Override
    public Mono<DisposableServer> bind() {
        return Mono.deferContextual(context -> Mono.just((Object)context.get(TransportImpl.ReceiverContext.class))).flatMap(context -> this.newHttpServer((TransportImpl.ReceiverContext)context).handle((request, response) -> this.onMessage((TransportImpl.ReceiverContext)context, (HttpServerRequest)request, (HttpServerResponse)response)).bind().cast(DisposableServer.class));
    }

    private HttpServer newHttpServer(TransportImpl.ReceiverContext context) {
        return (HttpServer)((HttpServer)((HttpServer)((HttpServer)HttpServer.create().runOn(context.loopResources())).port(this.config.port()).childOption(ChannelOption.TCP_NODELAY, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true)).childOption(ChannelOption.SO_REUSEADDR, (Object)true);
    }

    private Mono<Void> onMessage(TransportImpl.ReceiverContext context, HttpServerRequest request, HttpServerResponse response) {
        return response.sendWebsocket((inbound, outbound) -> inbound.receive().retain().doOnNext(context::onMessage).then());
    }
}

