/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime;

import io.quarkus.narayana.jta.runtime.TransactionScopedNotifier;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;

public class NotifyingUserTransaction
extends TransactionScopedNotifier
implements UserTransaction {
    private static final Logger LOG = Logger.getLogger(NotifyingUserTransaction.class);
    private final UserTransaction delegate;

    public NotifyingUserTransaction(UserTransaction delegate) {
        this.delegate = delegate;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.delegate.begin();
        this.initialized(this.getTransactionId());
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionScopedNotifier.TransactionId id = this.getTransactionId();
        this.beforeDestroyed(id);
        try {
            this.delegate.commit();
        }
        finally {
            this.destroyed(id);
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionScopedNotifier.TransactionId id = this.getTransactionId();
        try {
            this.beforeDestroyed(id);
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to fire @BeforeDestroyed(TransactionScoped.class)", t);
        }
        try {
            this.delegate.rollback();
        }
        finally {
            this.destroyed(id);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.delegate.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.delegate.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.delegate.setTransactionTimeout(seconds);
    }
}

