/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.kubernetes.spi.RoleRef;
import io.quarkus.kubernetes.spi.Subject;
import java.util.Collections;
import java.util.Map;

public final class KubernetesRoleBindingBuildItem
extends MultiBuildItem {
    private final String name;
    private final RoleRef roleRef;
    private final String target;
    private final Subject[] subjects;
    private final Map<String, String> labels;

    public KubernetesRoleBindingBuildItem(String role, boolean clusterWide) {
        this(null, role, clusterWide, null);
    }

    public KubernetesRoleBindingBuildItem(String name, String role, boolean clusterWide) {
        this(name, role, clusterWide, null);
    }

    public KubernetesRoleBindingBuildItem(String name, String role, boolean clusterWide, String target) {
        this(name, target, Collections.emptyMap(), new RoleRef(role, clusterWide), new Subject("", "ServiceAccount", name, null));
    }

    public KubernetesRoleBindingBuildItem(String name, String target, Map<String, String> labels, RoleRef roleRef, Subject ... subjects) {
        this.name = name;
        this.target = target;
        this.labels = labels;
        this.roleRef = roleRef;
        this.subjects = subjects;
    }

    public String getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public RoleRef getRoleRef() {
        return this.roleRef;
    }

    public Subject[] getSubjects() {
        return this.subjects;
    }
}

