/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public interface CompilationProvider {
    public Set<String> handledExtensions();

    default public Set<String> handledSourcePaths() {
        return Collections.emptySet();
    }

    public void compile(Set<File> var1, Context var2);

    public Path getSourcePath(Path var1, Set<String> var2, String var3);

    public static class Context {
        private final String name;
        private final Set<File> classpath;
        private final File projectDirectory;
        private final File sourceDirectory;
        private final File outputDirectory;
        private final Charset sourceEncoding;
        private final List<String> compilerOptions;
        private final String sourceJavaVersion;
        private final String targetJvmVersion;
        private final List<String> compilePluginArtifacts;
        private final List<String> compilerPluginOptions;

        public Context(String name, Set<File> classpath, File projectDirectory, File sourceDirectory, File outputDirectory, String sourceEncoding, List<String> compilerOptions, String sourceJavaVersion, String targetJvmVersion, List<String> compilePluginArtifacts, List<String> compilerPluginOptions) {
            this.name = name;
            this.classpath = classpath;
            this.projectDirectory = projectDirectory;
            this.sourceDirectory = sourceDirectory;
            this.outputDirectory = outputDirectory;
            this.sourceEncoding = sourceEncoding == null ? StandardCharsets.UTF_8 : Charset.forName(sourceEncoding);
            this.compilerOptions = compilerOptions == null ? new ArrayList() : compilerOptions;
            this.sourceJavaVersion = sourceJavaVersion;
            this.targetJvmVersion = targetJvmVersion;
            this.compilePluginArtifacts = compilePluginArtifacts;
            this.compilerPluginOptions = compilerPluginOptions;
        }

        public String getName() {
            return this.name;
        }

        public Set<File> getClasspath() {
            return this.classpath;
        }

        public File getProjectDirectory() {
            return this.projectDirectory;
        }

        public File getSourceDirectory() {
            return this.sourceDirectory;
        }

        public File getOutputDirectory() {
            return this.outputDirectory;
        }

        public Charset getSourceEncoding() {
            return this.sourceEncoding;
        }

        public List<String> getCompilerOptions() {
            return this.compilerOptions;
        }

        public String getSourceJavaVersion() {
            return this.sourceJavaVersion;
        }

        public String getTargetJvmVersion() {
            return this.targetJvmVersion;
        }

        public List<String> getCompilePluginArtifacts() {
            return this.compilePluginArtifacts;
        }

        public List<String> getCompilerPluginOptions() {
            return this.compilerPluginOptions;
        }
    }
}

