/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.net.SocketAddress;

public class TcpMetricsHandler
extends ChannelDuplexHandler {
    final MeterRegistry registry = Metrics.globalRegistry;
    final String name;
    final String remoteAddress;
    final boolean onServer;
    final DistributionSummary dataReceived;
    final DistributionSummary dataSent;
    final Counter errorCount;

    public TcpMetricsHandler(String name, String remoteAddress, boolean onServer) {
        this.name = name;
        this.remoteAddress = remoteAddress;
        this.onServer = onServer;
        this.dataReceived = DistributionSummary.builder((String)(name + ".data.received")).baseUnit("bytes").description("Amount of the data that is received, in bytes").tags(new String[]{"remote.address", remoteAddress, "uri", "tcp"}).register(this.registry);
        this.dataSent = DistributionSummary.builder((String)(name + ".data.sent")).baseUnit("bytes").description("Amount of the data that is sent, in bytes").tags(new String[]{"remote.address", remoteAddress, "uri", "tcp"}).register(this.registry);
        this.errorCount = Counter.builder((String)(name + ".errors")).description("Number of the errors that are occurred").tags(new String[]{"remote.address", remoteAddress, "uri", "tcp"}).register(this.registry);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (!this.onServer) {
            ctx.pipeline().addAfter("reactor.left.tcpMetricsHandler", "reactor.left.connectMetricsHandler", (ChannelHandler)new ConnectMetricsHandler(this.registry, this.name, this.remoteAddress));
        }
        if (ctx.pipeline().get(SslHandler.class) != null) {
            ctx.pipeline().addAfter("reactor.left.sslHandler", "reactor.left.sslMetricsHandler", (ChannelHandler)new TlsMetricsHandler(this.registry, this.name, this.remoteAddress));
        }
        super.channelRegistered(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer;
        if (msg instanceof ByteBuf && (buffer = (ByteBuf)msg).readableBytes() > 0) {
            this.dataReceived.record((double)buffer.readableBytes());
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf buffer;
        if (msg instanceof ByteBuf && (buffer = (ByteBuf)msg).readableBytes() > 0) {
            this.dataSent.record((double)buffer.readableBytes());
        }
        super.write(ctx, msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.errorCount.increment();
        super.exceptionCaught(ctx, cause);
    }

    public MeterRegistry registry() {
        return this.registry;
    }

    public String name() {
        return this.name;
    }

    static final class ConnectMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        Timer.Sample connectTimeSample;
        final MeterRegistry registry;
        final String name;
        final String remoteAddress;

        ConnectMetricsHandler(MeterRegistry registry, String name, String remoteAddress) {
            this.registry = registry;
            this.name = name;
            this.remoteAddress = remoteAddress;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            this.connectTimeSample = Timer.start((MeterRegistry)this.registry);
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener(future -> {
                ctx.pipeline().remove((ChannelHandler)this);
                String status = future.isSuccess() ? "SUCCESS" : "ERROR";
                Timer connectTime = Timer.builder((String)(this.name + ".connect.time")).tags(new String[]{"remote.address", this.remoteAddress, "status", status}).description("Time that is spent for connecting to the remote address").register(this.registry);
                this.connectTimeSample.stop(connectTime);
            });
        }
    }

    static final class TlsMetricsHandler
    extends ChannelInboundHandlerAdapter {
        Timer.Sample tlsHandshakeTimeSample;
        final MeterRegistry registry;
        final String name;
        final String remoteAddress;

        TlsMetricsHandler(MeterRegistry registry, String name, String remoteAddress) {
            this.registry = registry;
            this.name = name;
            this.remoteAddress = remoteAddress;
            this.tlsHandshakeTimeSample = Timer.start((MeterRegistry)registry);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                ctx.pipeline().remove((ChannelHandler)this);
                SslHandshakeCompletionEvent handshake = (SslHandshakeCompletionEvent)evt;
                String status = handshake.isSuccess() ? "SUCCESS" : "ERROR";
                Timer tlsHandshakeTime = Timer.builder((String)(this.name + ".tls.handshake.time")).tags(new String[]{"remote.address", this.remoteAddress, "status", status}).description("Time that is spent for TLS handshake").register(this.registry);
                this.tlsHandshakeTimeSample.stop(tlsHandshakeTime);
            }
            super.userEventTriggered(ctx, evt);
        }
    }
}

