/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.internal.shaded.reactor.pool;

import java.time.Duration;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.internal.shaded.reactor.pool.AbstractPool;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PoolShutdownException;
import reactor.netty.internal.shaded.reactor.pool.PooledRef;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

abstract class SimplePool<POOLABLE>
extends AbstractPool<POOLABLE> {
    final Queue<QueuePooledRef<POOLABLE>> elements = (Queue)Queues.unboundedMultiproducer().get();
    volatile int acquired;
    private static final AtomicIntegerFieldUpdater<SimplePool> ACQUIRED = AtomicIntegerFieldUpdater.newUpdater(SimplePool.class, "acquired");
    volatile int wip;
    private static final AtomicIntegerFieldUpdater<SimplePool> WIP = AtomicIntegerFieldUpdater.newUpdater(SimplePool.class, "wip");

    SimplePool(PoolConfig<POOLABLE> poolConfig) {
        super(poolConfig, Loggers.getLogger(SimplePool.class));
    }

    @Override
    public Mono<Integer> warmup() {
        if (this.poolConfig.allocationStrategy().permitMinimum() > 0) {
            return Mono.defer(() -> {
                int initSize = this.poolConfig.allocationStrategy().getPermits(0);
                Mono[] allWarmups = new Mono[initSize];
                for (int i = 0; i < initSize; ++i) {
                    long start = this.clock.millis();
                    allWarmups[i] = this.poolConfig.allocator().doOnNext(p -> {
                        this.metricsRecorder.recordAllocationSuccessAndLatency(this.clock.millis() - start);
                        this.elements.offer(this.createSlot(p));
                    }).doOnError(e -> {
                        this.metricsRecorder.recordAllocationFailureAndLatency(this.clock.millis() - start);
                        this.poolConfig.allocationStrategy().returnPermits(1);
                    });
                }
                return Flux.concat((Publisher[])allWarmups).reduce((Object)0, (count, p) -> count + 1);
            });
        }
        return Mono.just((Object)0);
    }

    @Nullable
    abstract AbstractPool.Borrower<POOLABLE> pendingPoll();

    abstract boolean pendingOffer(AbstractPool.Borrower<POOLABLE> var1);

    @Override
    public Mono<PooledRef<POOLABLE>> acquire() {
        return new QueueBorrowerMono(this, Duration.ZERO);
    }

    @Override
    public Mono<PooledRef<POOLABLE>> acquire(Duration timeout) {
        return new QueueBorrowerMono(this, timeout);
    }

    @Override
    void doAcquire(AbstractPool.Borrower<POOLABLE> borrower) {
        if (this.isDisposed()) {
            borrower.fail(new PoolShutdownException());
            return;
        }
        this.pendingOffer(borrower);
        this.drain();
    }

    @Override
    boolean elementOffer(POOLABLE element) {
        return this.elements.offer(this.createSlot(element));
    }

    QueuePooledRef<POOLABLE> createSlot(POOLABLE element) {
        return new QueuePooledRef<POOLABLE>(this, element);
    }

    QueuePooledRef<POOLABLE> recycleSlot(QueuePooledRef<POOLABLE> slot) {
        return new QueuePooledRef<POOLABLE>(slot);
    }

    @Override
    public int idleSize() {
        return this.elements.size();
    }

    final void maybeRecycleAndDrain(QueuePooledRef<POOLABLE> poolSlot) {
        if (!this.isDisposed()) {
            if (!this.poolConfig.evictionPredicate().test(poolSlot.poolable, poolSlot)) {
                this.metricsRecorder.recordRecycled();
                this.elements.offer(this.recycleSlot(poolSlot));
                this.drain();
            } else {
                this.destroyPoolable(poolSlot).subscribe(null, e -> this.drain(), this::drain);
            }
        } else {
            this.destroyPoolable(poolSlot).subscribe(null, e -> this.drain(), this::drain);
        }
    }

    void drain() {
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    private void drainLoop() {
        int missed = 1;
        while (true) {
            int availableCount = this.elements.size();
            int pendingCount = PENDING_COUNT.get(this);
            int estimatedPermitCount = this.poolConfig.allocationStrategy().estimatePermitCount();
            if (availableCount == 0) {
                if (pendingCount > 0 && estimatedPermitCount > 0) {
                    AbstractPool.Borrower<POOLABLE> borrower = this.pendingPoll();
                    if (borrower == null) continue;
                    ACQUIRED.incrementAndGet(this);
                    int permits = this.poolConfig.allocationStrategy().getPermits(1);
                    if (borrower.get() || permits == 0) {
                        ACQUIRED.decrementAndGet(this);
                        continue;
                    }
                    borrower.stopPendingCountdown();
                    long start = this.clock.millis();
                    Mono allocator = this.poolConfig.allocator();
                    Scheduler s = this.poolConfig.acquisitionScheduler();
                    if (s != Schedulers.immediate()) {
                        allocator = allocator.publishOn(s);
                    }
                    allocator.subscribe(newInstance -> borrower.deliver(this.createSlot(newInstance)), e -> {
                        this.metricsRecorder.recordAllocationFailureAndLatency(this.clock.millis() - start);
                        ACQUIRED.decrementAndGet(this);
                        this.poolConfig.allocationStrategy().returnPermits(1);
                        borrower.fail((Throwable)e);
                    }, () -> this.metricsRecorder.recordAllocationSuccessAndLatency(this.clock.millis() - start));
                    int toWarmup = permits - 1;
                    for (int extra = 1; extra <= toWarmup; ++extra) {
                        this.logger.debug("warming up extra resource {}/{}", new Object[]{extra, toWarmup});
                        allocator.subscribe(newInstance -> {
                            this.elements.offer(new QueuePooledRef<Object>(this, newInstance));
                            this.drain();
                        }, e -> {
                            this.metricsRecorder.recordAllocationFailureAndLatency(this.clock.millis() - start);
                            ACQUIRED.decrementAndGet(this);
                            this.poolConfig.allocationStrategy().returnPermits(1);
                        }, () -> this.metricsRecorder.recordAllocationSuccessAndLatency(this.clock.millis() - start));
                    }
                }
            } else if (pendingCount > 0) {
                QueuePooledRef slot = this.elements.poll();
                if (slot == null) continue;
                if (this.poolConfig.evictionPredicate().test(slot.poolable, slot)) {
                    this.destroyPoolable(slot).subscribe(null, e -> this.drain(), this::drain);
                    continue;
                }
                AbstractPool.Borrower inner = this.pendingPoll();
                if (inner == null) {
                    this.elements.offer(slot);
                    continue;
                }
                inner.stopPendingCountdown();
                ACQUIRED.incrementAndGet(this);
                this.poolConfig.acquisitionScheduler().schedule(() -> inner.deliver(slot));
            }
            if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
        }
    }

    private static final class QueuePoolRecyclerMono<T>
    extends Mono<Void>
    implements Scannable {
        final Publisher<Void> source;
        final AtomicReference<QueuePooledRef<T>> slotRef;

        QueuePoolRecyclerMono(Publisher<Void> source, QueuePooledRef<T> poolSlot) {
            this.source = source;
            this.slotRef = new AtomicReference<QueuePooledRef<T>>(poolSlot);
        }

        public void subscribe(CoreSubscriber<? super Void> actual) {
            QueuePooledRef slot = this.slotRef.getAndSet(null);
            if (slot == null) {
                Operators.complete(actual);
            } else {
                slot.markReleased();
                QueuePoolRecyclerInner qpr = new QueuePoolRecyclerInner(actual, slot);
                this.source.subscribe(qpr);
            }
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.source;
            }
            return null;
        }
    }

    private static final class QueuePoolRecyclerInner<T>
    implements CoreSubscriber<Void>,
    Scannable,
    Subscription {
        final CoreSubscriber<? super Void> actual;
        final SimplePool<T> pool;
        QueuePooledRef<T> pooledRef;
        Subscription upstream;
        long start;
        volatile int once;
        static final AtomicIntegerFieldUpdater<QueuePoolRecyclerInner> ONCE = AtomicIntegerFieldUpdater.newUpdater(QueuePoolRecyclerInner.class, "once");

        QueuePoolRecyclerInner(CoreSubscriber<? super Void> actual, QueuePooledRef<T> pooledRef) {
            this.actual = actual;
            this.pooledRef = Objects.requireNonNull(pooledRef, "pooledRef");
            this.pool = pooledRef.pool;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.actual.onSubscribe((Subscription)this);
                this.start = this.pool.clock.millis();
            }
        }

        public void onNext(Void o) {
        }

        public void onError(Throwable throwable) {
            QueuePooledRef<T> slot = this.pooledRef;
            this.pooledRef = null;
            if (slot == null) {
                Operators.onErrorDropped((Throwable)throwable, (Context)this.actual.currentContext());
                return;
            }
            if (ONCE.compareAndSet(this, 0, 1)) {
                ACQUIRED.decrementAndGet(this.pool);
            }
            this.pool.metricsRecorder.recordResetLatency(this.pool.clock.millis() - this.start);
            this.pool.destroyPoolable(slot).subscribe(null, null, this.pool::drain);
            this.actual.onError(throwable);
        }

        public void onComplete() {
            QueuePooledRef<T> slot = this.pooledRef;
            this.pooledRef = null;
            if (slot == null) {
                return;
            }
            if (ONCE.compareAndSet(this, 0, 1)) {
                ACQUIRED.decrementAndGet(this.pool);
            }
            this.pool.metricsRecorder.recordResetLatency(this.pool.clock.millis() - this.start);
            this.pool.maybeRecycleAndDrain(slot);
            this.actual.onComplete();
        }

        public void request(long l) {
            if (Operators.validate((long)l)) {
                this.upstream.request(l);
                if (ONCE.compareAndSet(this, 0, 1)) {
                    ACQUIRED.decrementAndGet(this.pool);
                }
            }
        }

        public void cancel() {
        }

        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.upstream;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return false;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.pooledRef == null;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.pooledRef == null ? 0 : 1;
            }
            return null;
        }
    }

    static final class QueueBorrowerMono<T>
    extends Mono<PooledRef<T>> {
        final SimplePool<T> parent;
        final Duration acquireTimeout;

        QueueBorrowerMono(SimplePool<T> pool, Duration acquireTimeout) {
            this.parent = pool;
            this.acquireTimeout = acquireTimeout;
        }

        public void subscribe(CoreSubscriber<? super PooledRef<T>> actual) {
            Objects.requireNonNull(actual, "subscribing with null");
            AbstractPool.Borrower<T> borrower = new AbstractPool.Borrower<T>(actual, this.parent, this.acquireTimeout);
            actual.onSubscribe(borrower);
        }
    }

    static final class QueuePooledRef<T>
    extends AbstractPool.AbstractPooledRef<T> {
        final SimplePool<T> pool;

        QueuePooledRef(SimplePool<T> pool, T poolable) {
            super(poolable, pool.metricsRecorder, pool.clock);
            this.pool = pool;
        }

        QueuePooledRef(QueuePooledRef<T> oldRef) {
            super(oldRef);
            this.pool = oldRef.pool;
        }

        @Override
        public Mono<Void> release() {
            return Mono.defer(() -> {
                Publisher<Void> cleaner;
                if (STATE.get(this) == 2) {
                    return Mono.empty();
                }
                if (this.pool.isDisposed()) {
                    ACQUIRED.decrementAndGet(this.pool);
                    this.markReleased();
                    return this.pool.destroyPoolable(this);
                }
                try {
                    cleaner = this.pool.poolConfig.releaseHandler().apply(this.poolable);
                }
                catch (Throwable e) {
                    ACQUIRED.decrementAndGet(this.pool);
                    this.markReleased();
                    return Mono.error((Throwable)new IllegalStateException("Couldn't apply cleaner function", e));
                }
                return new QueuePoolRecyclerMono(cleaner, this);
            });
        }

        @Override
        public Mono<Void> invalidate() {
            return Mono.defer(() -> {
                if (this.markInvalidate()) {
                    ACQUIRED.decrementAndGet(this.pool);
                    return this.pool.destroyPoolable(this).then(Mono.fromRunnable(this.pool::drain));
                }
                return Mono.empty();
            });
        }
    }
}

