/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractMinMaxSumCountAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.MinMaxSumCountAccumulation;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DoubleMinMaxSumCountAggregator
extends AbstractMinMaxSumCountAggregator {
    DoubleMinMaxSumCountAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, MetricDescriptor descriptor) {
        super(resource, instrumentationLibraryInfo, descriptor);
    }

    @Override
    public AggregatorHandle<MinMaxSumCountAccumulation> createHandle() {
        return new Handle();
    }

    @Override
    public MinMaxSumCountAccumulation accumulateDouble(double value) {
        return MinMaxSumCountAccumulation.create(1L, value, value, value);
    }

    static final class Handle
    extends AggregatorHandle<MinMaxSumCountAccumulation> {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final DoubleState current = new DoubleState();

        Handle() {
        }

        @Override
        protected MinMaxSumCountAccumulation doAccumulateThenReset() {
            this.lock.writeLock().lock();
            try {
                MinMaxSumCountAccumulation toReturn = MinMaxSumCountAccumulation.create(this.current.count, this.current.sum, this.current.min, this.current.max);
                this.current.reset();
                MinMaxSumCountAccumulation minMaxSumCountAccumulation = toReturn;
                return minMaxSumCountAccumulation;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        protected void doRecordDouble(double value) {
            this.lock.writeLock().lock();
            try {
                this.current.record(value);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private static final class DoubleState {
            private long count;
            private double sum;
            private double min;
            private double max;

            public DoubleState() {
                this.reset();
            }

            private void reset() {
                this.sum = 0.0;
                this.count = 0L;
                this.min = Double.POSITIVE_INFINITY;
                this.max = Double.NEGATIVE_INFINITY;
            }

            public void record(double value) {
                ++this.count;
                this.sum += value;
                this.min = Math.min(value, this.min);
                this.max = Math.max(value, this.max);
            }
        }
    }
}

