/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import io.openliberty.tools.common.plugins.util.OSUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;

public class ServerStatusUtil {
    public static boolean isServerRunning(File installDirectory, File outputDirectory, String serverName) {
        File sLock = new File(outputDirectory, serverName + "/workarea/.sLock");
        File sCommand = new File(outputDirectory, serverName + "/workarea/.sCommand");
        File pidFile = new File(outputDirectory, ".pid/" + serverName + ".pid");
        String serverStatusCmd = installDirectory.getAbsolutePath() + "/bin/server";
        if (OSUtil.isWindows()) {
            File sLockBak = new File(sLock.getPath() + ".bak");
            if (!sLock.exists() || sLock.renameTo(sLockBak)) {
                sLockBak.renameTo(sLock);
                return false;
            }
        } else {
            if (pidFile.exists()) {
                try {
                    String pid = new String(Files.readAllBytes(Paths.get(pidFile.getPath(), new String[0])));
                    Process p = Runtime.getRuntime().exec("ps " + pid);
                    p.waitFor(10L, TimeUnit.SECONDS);
                    if (p.exitValue() != 0) {
                        return false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!sLock.exists() || !sCommand.exists()) {
                return false;
            }
            try {
                String[] env = new String[]{"WLP_OUTPUT_DIR=" + outputDirectory};
                String[] cmd = new String[]{serverStatusCmd, "status", serverName};
                Process p = Runtime.getRuntime().exec(cmd, env);
                p.waitFor(10L, TimeUnit.SECONDS);
                if (p.exitValue() != 0) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

