/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jdbc.spring;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.event.BeanPreDestroyEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.jdbc.spring.HibernatePresenceCondition;
import jakarta.inject.Singleton;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Factory
@Requirements(value={@Requires(classes={DataSourceTransactionManager.class}), @Requires(condition=HibernatePresenceCondition.class)})
@Internal
public class DataSourceTransactionManagerFactory {
    @EachBean(value=DataSource.class)
    DataSourceTransactionManager dataSourceTransactionManager(DataSource dataSource) {
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager(dataSource);
        dataSourceTransactionManager.afterPropertiesSet();
        return dataSourceTransactionManager;
    }

    @Singleton
    TransactionAwareDataSourceListener transactionAwareDataSourceListener() {
        return new TransactionAwareDataSourceListener();
    }

    @Singleton
    final BeanPreDestroyEventListener<DataSource> transactionAwareDataSourceListenerUnwrapper() {
        return event -> {
            DataSource ds = (DataSource)event.getBean();
            if (ds instanceof TransactionAwareDataSourceProxy) {
                return ((TransactionAwareDataSourceProxy)ds).getTargetDataSource();
            }
            return ds;
        };
    }

    private static class TransactionAwareDataSourceListener
    implements BeanCreatedEventListener<DataSource> {
        private TransactionAwareDataSourceListener() {
        }

        public DataSource onCreated(BeanCreatedEvent<DataSource> event) {
            DataSource dataSource = (DataSource)event.getBean();
            if (dataSource instanceof TransactionAwareDataSourceProxy) {
                return dataSource;
            }
            return new TransactionAwareDataSourceProxy(dataSource);
        }
    }
}

