/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jdbc.nativeimage;

import com.oracle.svm.core.annotate.AutomaticFeature;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.graal.AutomaticFeatureUtils;
import java.util.Arrays;
import java.util.Collections;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Internal
final class JdbcFeature
implements Feature {
    private static final String H2_DRIVER = "org.h2.Driver";
    private static final String POSTGRESQL_DRIVER = "org.postgresql.Driver";
    private static final String SQL_SERVER_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String MARIADB_DRIVER = "org.mariadb.jdbc.Driver";
    private static final String MYSQL_DRIVER = "com.mysql.cj.jdbc.Driver";

    JdbcFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.handleH2(access);
        this.handlePostgres(access);
        this.handleMariadb(access);
        this.handleSqlServer(access);
        this.handleMySql(access);
    }

    private void handleH2(Feature.BeforeAnalysisAccess access) {
        Class h2Driver = access.findClassByName(H2_DRIVER);
        if (h2Driver != null) {
            AutomaticFeatureUtils.registerFieldsAndMethodsWithReflectiveAccess((Feature.BeforeAnalysisAccess)access, (String)"org.h2.mvstore.db.MVTableEngine");
            AutomaticFeatureUtils.registerClassForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)H2_DRIVER);
            AutomaticFeatureUtils.initializeAtBuildTime((Feature.BeforeAnalysisAccess)access, (String)H2_DRIVER);
            Collections.singletonList("org.h2.engine.Constants").forEach(s -> {
                AutomaticFeatureUtils.registerClassForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)s);
                AutomaticFeatureUtils.registerMethodsForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)s);
                AutomaticFeatureUtils.registerFieldsForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)s);
            });
            Arrays.asList("org.h2.store.fs.FilePathDisk", "org.h2.store.fs.FilePathMem", "org.h2.store.fs.FilePathMemLZF", "org.h2.store.fs.FilePathNioMem", "org.h2.store.fs.FilePathNioMemLZF", "org.h2.store.fs.FilePathSplit", "org.h2.store.fs.FilePathNio", "org.h2.store.fs.FilePathNioMapped", "org.h2.store.fs.FilePathAsync", "org.h2.store.fs.FilePathZip", "org.h2.store.fs.FilePathRetryOnInterrupt").forEach(c -> AutomaticFeatureUtils.registerClassForRuntimeReflectionAndReflectiveInstantiation((Feature.BeforeAnalysisAccess)access, (String)c));
            AutomaticFeatureUtils.addResourcePatterns((String[])new String[]{"META-INF/services/java.sql.Driver", "org/h2/util/data.zip"});
            AutomaticFeatureUtils.initializeAtBuildTime((Feature.BeforeAnalysisAccess)access, (String)"java.sql.DriverManager");
        }
    }

    private void handlePostgres(Feature.BeforeAnalysisAccess access) {
        Class postgresDriver = access.findClassByName(POSTGRESQL_DRIVER);
        if (postgresDriver != null) {
            AutomaticFeatureUtils.registerClassForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)POSTGRESQL_DRIVER);
            AutomaticFeatureUtils.initializeAtBuildTime((Feature.BeforeAnalysisAccess)access, (String[])new String[]{POSTGRESQL_DRIVER, "org.postgresql.util.SharedTimer"});
            AutomaticFeatureUtils.registerAllForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)"org.postgresql.PGProperty");
            AutomaticFeatureUtils.addResourcePatterns((String[])new String[]{"META-INF/services/java.sql.Driver"});
            AutomaticFeatureUtils.initializeAtBuildTime((Feature.BeforeAnalysisAccess)access, (String)"java.sql.DriverManager");
        }
    }

    private void handleMariadb(Feature.BeforeAnalysisAccess access) {
        Class mariaDriver = access.findClassByName(MARIADB_DRIVER);
        if (mariaDriver != null) {
            AutomaticFeatureUtils.registerFieldsAndMethodsWithReflectiveAccess((Feature.BeforeAnalysisAccess)access, (String)MARIADB_DRIVER);
            AutomaticFeatureUtils.addResourcePatterns((String[])new String[]{"META-INF/services/java.sql.Driver"});
            AutomaticFeatureUtils.registerFieldsAndMethodsWithReflectiveAccess((Feature.BeforeAnalysisAccess)access, (String)"org.mariadb.jdbc.util.Options");
            AutomaticFeatureUtils.initializePackagesAtBuildTime((String[])new String[]{"org.mariadb"});
            AutomaticFeatureUtils.initializePackagesAtRunTime((String[])new String[]{"org.mariadb.jdbc.credential.aws"});
            AutomaticFeatureUtils.initializePackagesAtRunTime((String[])new String[]{"org.mariadb.jdbc.internal.failover.impl"});
            AutomaticFeatureUtils.initializeAtRunTime((Feature.BeforeAnalysisAccess)access, (String)"org.mariadb.jdbc.internal.com.send.authentication.SendPamAuthPacket");
            AutomaticFeatureUtils.initializeAtBuildTime((Feature.BeforeAnalysisAccess)access, (String)"java.sql.DriverManager");
        }
    }

    private void handleSqlServer(Feature.BeforeAnalysisAccess access) {
        Class sqlServerDriver = access.findClassByName(SQL_SERVER_DRIVER);
        if (sqlServerDriver != null) {
            AutomaticFeatureUtils.registerFieldsAndMethodsWithReflectiveAccess((Feature.BeforeAnalysisAccess)access, (String)SQL_SERVER_DRIVER);
            AutomaticFeatureUtils.initializeAtBuildTime((Feature.BeforeAnalysisAccess)access, (String[])new String[]{SQL_SERVER_DRIVER, "com.microsoft.sqlserver.jdbc.Util", "com.microsoft.sqlserver.jdbc.SQLServerException", "com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty"});
            AutomaticFeatureUtils.addResourcePatterns((String[])new String[]{"META-INF/services/java.sql.Driver", "javax.crypto.Cipher.class"});
            AutomaticFeatureUtils.addResourceBundles((String[])new String[]{"com.microsoft.sqlserver.jdbc.SQLServerResource"});
            AutomaticFeatureUtils.initializeAtBuildTime((Feature.BeforeAnalysisAccess)access, (String)"java.sql.DriverManager");
        }
    }

    private void handleMySql(Feature.BeforeAnalysisAccess access) {
        Class mysqlDriver = access.findClassByName(MYSQL_DRIVER);
        if (mysqlDriver != null) {
            Arrays.asList("com.mysql.cj.exceptions.AssertionFailedException", "com.mysql.cj.exceptions.CJCommunicationsException", "com.mysql.cj.exceptions.CJConnectionFeatureNotAvailableException", "com.mysql.cj.exceptions.CJException", "com.mysql.cj.exceptions.CJOperationNotSupportedException", "com.mysql.cj.exceptions.CJPacketTooBigException", "com.mysql.cj.exceptions.CJTimeoutException", "com.mysql.cj.exceptions.ClosedOnExpiredPasswordException", "com.mysql.cj.exceptions.ConnectionIsClosedException", "com.mysql.cj.exceptions.DataConversionException", "com.mysql.cj.exceptions.DataReadException", "com.mysql.cj.exceptions.DataTruncationException", "com.mysql.cj.exceptions.FeatureNotAvailableException", "com.mysql.cj.exceptions.InvalidConnectionAttributeException", "com.mysql.cj.exceptions.MysqlErrorNumbers", "com.mysql.cj.exceptions.NumberOutOfRange", "com.mysql.cj.exceptions.OperationCancelledException", "com.mysql.cj.exceptions.PasswordExpiredException", "com.mysql.cj.exceptions.PropertyNotModifiableException", "com.mysql.cj.exceptions.RSAException", "com.mysql.cj.exceptions.SSLParamsException", "com.mysql.cj.exceptions.StatementIsClosedException", "com.mysql.cj.exceptions.UnableToConnectException", "com.mysql.cj.exceptions.UnsupportedConnectionStringException", "com.mysql.cj.exceptions.WrongArgumentException").forEach(name -> {
                AutomaticFeatureUtils.registerClassForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)name);
                AutomaticFeatureUtils.registerConstructorsForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)name);
            });
            AutomaticFeatureUtils.registerFieldsAndMethodsWithReflectiveAccess((Feature.BeforeAnalysisAccess)access, (String)MYSQL_DRIVER);
            AutomaticFeatureUtils.registerAllForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)"com.mysql.cj.log.StandardLogger");
            AutomaticFeatureUtils.registerAllForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)"com.mysql.cj.conf.url.SingleConnectionUrl");
            AutomaticFeatureUtils.registerAllForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)"com.mysql.cj.conf.url.XDevApiConnectionUrl");
            AutomaticFeatureUtils.registerAllForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)"com.mysql.cj.protocol.x.SyncFlushDeflaterOutputStream");
            AutomaticFeatureUtils.registerAllForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)"java.util.zip.InflaterInputStream");
            AutomaticFeatureUtils.registerFieldsAndMethodsWithReflectiveAccess((Feature.BeforeAnalysisAccess)access, (String)"com.mysql.cj.protocol.StandardSocketFactory");
            AutomaticFeatureUtils.registerFieldsAndMethodsWithReflectiveAccess((Feature.BeforeAnalysisAccess)access, (String)"com.mysql.cj.jdbc.AbandonedConnectionCleanupThread");
            AutomaticFeatureUtils.addResourcePatterns((String[])new String[]{"META-INF/services/java.sql.Driver", "com/mysql/cj/TlsSettings.properties", "com/mysql/cj/LocalizedErrorMessages.properties", "com/mysql/cj/util/TimeZoneMapping.properties"});
            AutomaticFeatureUtils.addResourceBundles((String[])new String[]{"com.mysql.cj.LocalizedErrorMessages"});
            AutomaticFeatureUtils.initializeAtRunTime((Feature.BeforeAnalysisAccess)access, (String)"java.sql.DriverManager");
        }
    }
}

