/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import io.micronaut.serde.support.util.SubtypeInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Internal
record DeserBeanSubtypeInfo<T>(Class<T> beanType, @NonNull Map<String, DeserBean<? extends T>> subtypes, SubtypeInfo info, @Nullable DeserBean<? extends T> defaultType) {
    @NonNull
    DeserBean<? extends T> findDeserBean(@Nullable String discriminatorValue) throws SerdeException {
        DeserBean<? extends T> deserBean = discriminatorValue == null ? this.defaultType : this.subtypes.getOrDefault(discriminatorValue, this.defaultType);
        if (deserBean == null) {
            throw this.unknownSuperTypeException();
        }
        return deserBean;
    }

    @NonNull
    public SerdeException unknownSuperTypeException() {
        return new SerdeException("Could not resolve subtype of [" + this.beanType.getName() + "] missing type id property '" + this.info.discriminatorName() + "'");
    }

    @Nullable
    static <T> DeserBeanSubtypeInfo<T> create(@Nullable SubtypeInfo subtypeInfo, BeanIntrospection<T> introspection, Deserializer.DecoderContext decoderContext, DeserBean<T> superTypeDeserBean, DeserializationConfiguration deserializationConfiguration, DeserBeanRegistry deserBeanRegistry) throws SerdeException {
        if (subtypeInfo == null) {
            return null;
        }
        Class superType = introspection.getBeanType();
        Collection subtypeIntrospections = decoderContext.getDeserializableSubtypes(superType);
        HashMap subtypes = CollectionUtils.newHashMap((int)subtypeIntrospections.size());
        Class defaultType = introspection.classValue(DefaultImplementation.class).orElseGet(() -> introspection.classValue("defaultImpl").orElse(null));
        if (defaultType == null && !deserializationConfiguration.isSubtypesRequireDefaultImpl()) {
            defaultType = introspection.getBeanType();
        }
        DeserBean<T> defaultDeserType = null;
        if (defaultType != null && "com.fasterxml.jackson.annotation.JsonTypeInfo".equals(introspection.stringValue(SerdeConfig.SerSubtyped.class, "defaultImpl").orElse(null))) {
            defaultType = null;
        }
        if (introspection.getBeanType().equals(defaultType)) {
            defaultDeserType = superTypeDeserBean;
        }
        for (BeanIntrospection subtypeIntrospection : subtypeIntrospections) {
            String[] names;
            Class subBeanType = subtypeIntrospection.getBeanType();
            DeserBean deserBean = deserBeanRegistry.getDeserializableBean(Argument.of((Class)subBeanType), decoderContext);
            String[] types = subtypeInfo.subtypes().get(subBeanType);
            if (types != null) {
                for (String type : types) {
                    subtypes.put(type, deserBean);
                }
            }
            if (defaultDeserType == null && defaultType != null && defaultType.equals(subBeanType)) {
                defaultDeserType = deserBean;
            }
            subtypeIntrospection.stringValue(SerdeConfig.class, "typeName").ifPresent(name -> subtypes.put(name, deserBean));
            for (String name2 : names = subtypeIntrospection.stringValues(SerdeConfig.class, "typeNames")) {
                subtypes.put(name2, deserBean);
            }
        }
        if (defaultDeserType == null && defaultType != null && !subtypeIntrospections.isEmpty()) {
            defaultDeserType = defaultType == introspection.getBeanType() ? superTypeDeserBean : deserBeanRegistry.getDeserializableBean(Argument.of((Class)defaultType), decoderContext);
        }
        return new DeserBeanSubtypeInfo<T>(introspection.getBeanType(), subtypes, subtypeInfo, defaultDeserType);
    }
}

