/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public abstract class JacksonEncoder
extends LimitingStream
implements Encoder {
    protected final JsonGenerator generator;
    @Nullable
    private final JacksonEncoder parent;
    private JacksonEncoder child = null;

    private JacksonEncoder(@NonNull JacksonEncoder parent, LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
        this.generator = parent.generator;
        this.parent = parent;
    }

    private JacksonEncoder(@NonNull JsonGenerator generator, LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
        this.generator = generator;
        this.parent = null;
    }

    @NonNull
    public static Encoder create(@NonNull JsonGenerator generator) {
        return JacksonEncoder.create(generator, DEFAULT_LIMITS);
    }

    @NonNull
    @Internal
    public static Encoder create(@NonNull JsonGenerator generator, @NonNull LimitingStream.RemainingLimits remainingLimits) {
        Objects.requireNonNull(generator, "generator");
        return new ReuseChildEncoder(generator, remainingLimits);
    }

    void checkChild() {
        if (this.child != null) {
            throw new IllegalStateException("There is still an unfinished child generator");
        }
        if (this.parent != null && this.parent.child != this) {
            throw new IllegalStateException("This child generator has already completed");
        }
    }

    JacksonEncoder makeArrayChildEncoder() throws SerdeException {
        return new ArrayEncoder(this, this.childLimits());
    }

    public final Encoder encodeArray(Argument<?> type) throws IOException {
        JacksonEncoder arrayEncoder;
        this.checkChild();
        this.generator.writeStartArray();
        this.child = arrayEncoder = this.makeArrayChildEncoder();
        return arrayEncoder;
    }

    JacksonEncoder makeObjectChildEncoder() throws SerdeException {
        return new ObjectEncoder(this, this.childLimits());
    }

    public final Encoder encodeObject(Argument<?> type) throws IOException {
        JacksonEncoder objectEncoder;
        this.checkChild();
        this.generator.writeStartObject();
        this.child = objectEncoder = this.makeObjectChildEncoder();
        return objectEncoder;
    }

    public final void finishStructure() throws IOException {
        this.checkChild();
        this.finishStructureToken();
        if (this.parent != null) {
            this.parent.child = null;
        }
    }

    public final void close() throws IOException {
        this.finishStructure();
    }

    protected abstract void finishStructureToken() throws IOException;

    public String currentPath() {
        JsonStreamContext outputContext = this.generator.getOutputContext();
        return outputContext.pathAsPointer().toString();
    }

    public final void encodeKey(@NonNull String key) throws IOException {
        Objects.requireNonNull(key, "key");
        this.generator.writeFieldName(key);
    }

    public final void encodeString(@NonNull String value) throws IOException {
        Objects.requireNonNull(value, "value");
        this.generator.writeString(value);
    }

    public final void encodeBoolean(boolean value) throws IOException {
        this.generator.writeBoolean(value);
    }

    public final void encodeByte(byte value) throws IOException {
        this.generator.writeNumber((short)value);
    }

    public final void encodeShort(short value) throws IOException {
        this.generator.writeNumber(value);
    }

    public final void encodeChar(char value) throws IOException {
        this.generator.writeNumber((int)value);
    }

    public final void encodeInt(int value) throws IOException {
        this.generator.writeNumber(value);
    }

    public final void encodeLong(long value) throws IOException {
        this.generator.writeNumber(value);
    }

    public final void encodeFloat(float value) throws IOException {
        this.generator.writeNumber(value);
    }

    public final void encodeDouble(double value) throws IOException {
        this.generator.writeNumber(value);
    }

    public final void encodeBigInteger(@NonNull BigInteger value) throws IOException {
        Objects.requireNonNull(value, "value");
        this.generator.writeNumber(value);
    }

    public final void encodeBigDecimal(@NonNull BigDecimal value) throws IOException {
        Objects.requireNonNull(value, "value");
        this.generator.writeNumber(value);
    }

    public void encodeBinary(byte @NonNull [] data) throws IOException {
        this.generator.writeBinary(data);
    }

    public final void encodeNull() throws IOException {
        this.generator.writeNull();
    }

    private static final class ReuseChildEncoder
    extends JacksonEncoder {
        private long type = 0L;
        private int depth = 0;

        ReuseChildEncoder(@NonNull JsonGenerator generator, LimitingStream.RemainingLimits remainingLimits) {
            super(generator, remainingLimits);
        }

        @Override
        protected void finishStructureToken() throws IOException {
            if (this.depth == 0) {
                throw new IllegalStateException("Not in structure");
            }
            this.decreaseDepth();
            --this.depth;
            if ((this.type & 1L) == 0L) {
                this.generator.writeEndObject();
            } else {
                this.generator.writeEndArray();
            }
            this.type >>>= 1;
        }

        @Override
        JacksonEncoder makeArrayChildEncoder() throws SerdeException {
            if (this.depth == 64) {
                return super.makeArrayChildEncoder();
            }
            this.increaseDepth();
            ++this.depth;
            this.type = this.type << 1 | 1L;
            return this;
        }

        @Override
        JacksonEncoder makeObjectChildEncoder() throws SerdeException {
            if (this.depth == 64) {
                return super.makeObjectChildEncoder();
            }
            this.increaseDepth();
            ++this.depth;
            this.type <<= 1;
            return this;
        }

        @Override
        void checkChild() {
        }
    }

    private static final class ArrayEncoder
    extends JacksonEncoder {
        ArrayEncoder(JacksonEncoder parent, LimitingStream.RemainingLimits remainingLimits) {
            super(parent, remainingLimits);
        }

        @Override
        protected void finishStructureToken() throws IOException {
            this.generator.writeEndArray();
        }
    }

    private static final class ObjectEncoder
    extends JacksonEncoder {
        ObjectEncoder(JacksonEncoder parent, LimitingStream.RemainingLimits remainingLimits) {
            super(parent, remainingLimits);
        }

        @Override
        protected void finishStructureToken() throws IOException {
            this.generator.writeEndObject();
        }
    }

    private static final class OuterEncoder
    extends JacksonEncoder {
        OuterEncoder(@NonNull JsonGenerator generator, LimitingStream.RemainingLimits remainingLimits) {
            super(generator, remainingLimits);
        }

        @Override
        protected void finishStructureToken() {
            throw new IllegalStateException("Not in structure");
        }
    }
}

