/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.exceptions.path;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.exceptions.path.DefaultCollectionItemReferencePath;
import io.micronaut.serde.exceptions.path.DefaultMapItemReferencePath;
import io.micronaut.serde.exceptions.path.DefaultPropertyReferencePath;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ReferencePath {
    public static ReferencePath ofProperty(Class<?> beanType, Argument<?> property) {
        return new DefaultPropertyReferencePath(beanType, property);
    }

    public static ReferencePath ofCollection(Class<?> type, Argument<?> collectionArgument, int index) {
        return new DefaultCollectionItemReferencePath(type, collectionArgument, index);
    }

    public static ReferencePath ofMap(Class<?> type, Argument<?> mapArgument, String key) {
        return new DefaultMapItemReferencePath(type, mapArgument, key);
    }

    public Argument<?> getArgument();
}

