/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.serde.ObjectMappers;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.SerializationConfiguration;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public interface ObjectMapper
extends JsonMapper {
    @NonNull
    default public String writeValueAsString(@NonNull Object object) throws IOException {
        Objects.requireNonNull(object, "Object cannot be null");
        return new String(this.writeValueAsBytes(object), StandardCharsets.UTF_8);
    }

    default public JsonMapper cloneWithFeatures(JsonFeatures features) {
        return this;
    }

    @NonNull
    default public ObjectMapper cloneWithConfiguration(@Nullable SerdeConfiguration configuration, @Nullable SerializationConfiguration serializationConfiguration, @Nullable DeserializationConfiguration deserializationConfiguration) {
        return this;
    }

    @NonNull
    default public SerdeRegistry getSerdeRegistry() {
        throw new UnsupportedOperationException("No accessible SerdeRegistry");
    }

    @NonNull
    public static ObjectMapper getDefault() {
        return ObjectMappers.resolveDefault();
    }

    @NonNull
    public static CloseableObjectMapper create(Map<String, Object> configuration, String ... packageNames) {
        return ObjectMappers.create(configuration, packageNames);
    }

    public static interface CloseableObjectMapper
    extends ObjectMapper,
    AutoCloseable {
        @Override
        public void close();
    }
}

