/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.web.router.AbstractRouteMatch;
import io.micronaut.web.router.ErrorRouteInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

@Internal
class ErrorRouteMatch<T, R>
extends AbstractRouteMatch<T, R> {
    private final Throwable error;
    private final Map<String, Object> variables;

    ErrorRouteMatch(Throwable error, ErrorRouteInfo<T, R> routeInfo, ConversionService conversionService) {
        super(routeInfo, conversionService);
        this.error = error;
        this.variables = new LinkedHashMap<String, Object>();
        for (Argument<?> argument : this.getArguments()) {
            if (!argument.getType().isInstance(error)) continue;
            this.variables.put(argument.getName(), error);
        }
    }

    @Override
    public Collection<Argument<?>> getRequiredArguments() {
        Argument<?>[] arguments = this.getArguments();
        ArrayList list = new ArrayList(arguments.length);
        for (Argument<?> argument : arguments) {
            if (argument.getType().isInstance(this.error)) continue;
            list.add(argument);
        }
        return list;
    }

    @Override
    public Map<String, Object> getVariableValues() {
        return this.variables;
    }

    public String toString() {
        return this.routeInfo.toString();
    }
}

