/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.http.scope;

import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.scope.AbstractConcurrentCustomScope;
import io.micronaut.context.scope.BeanCreationContext;
import io.micronaut.context.scope.CreatedBean;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.runtime.http.scope.RequestAware;
import io.micronaut.runtime.http.scope.RequestScope;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
class RequestCustomScope
extends AbstractConcurrentCustomScope<RequestScope>
implements ApplicationEventListener<HttpRequestTerminatedEvent> {
    public static final String SCOPED_BEANS_ATTRIBUTE = "io.micronaut.http.SCOPED_BEANS";

    public RequestCustomScope() {
        super(RequestScope.class);
    }

    public void close() {
        ServerRequestContext.currentRequest().ifPresent(this::destroyBeans);
    }

    public boolean isRunning() {
        return ServerRequestContext.currentRequest().isPresent();
    }

    public void onApplicationEvent(HttpRequestTerminatedEvent event) {
        this.destroyBeans((HttpRequest<?>)event.getSource());
    }

    @NonNull
    protected Map<BeanIdentifier, CreatedBean<?>> getScopeMap(boolean forCreation) {
        HttpRequest request = ServerRequestContext.currentRequest().orElse(null);
        if (request != null) {
            return this.getRequestAttributeMap(request, forCreation);
        }
        throw new IllegalStateException("No request present");
    }

    @NonNull
    protected <T> CreatedBean<T> doCreate(@NonNull BeanCreationContext<T> creationContext) {
        HttpRequest request = ServerRequestContext.currentRequest().orElse(null);
        CreatedBean createdBean = super.doCreate(creationContext);
        Object bean = createdBean.bean();
        if (bean instanceof RequestAware) {
            RequestAware aware = (RequestAware)bean;
            aware.setRequest(request);
        }
        return createdBean;
    }

    private void destroyBeans(HttpRequest<?> request) {
        ArgumentUtils.requireNonNull((String)"request", request);
        ConcurrentHashMap<BeanIdentifier, CreatedBean<?>> requestScopedBeans = this.getRequestAttributeMap(request, false);
        if (requestScopedBeans != null) {
            this.destroyScope(requestScopedBeans);
        }
    }

    private <T> ConcurrentHashMap<BeanIdentifier, CreatedBean<?>> getRequestAttributeMap(HttpRequest<T> httpRequest, boolean create) {
        MutableConvertibleValues<Object> attrs = httpRequest.getAttributes();
        Object o = attrs.getValue((CharSequence)SCOPED_BEANS_ATTRIBUTE);
        if (o instanceof ConcurrentHashMap) {
            return (ConcurrentHashMap)o;
        }
        if (create) {
            ConcurrentHashMap scopedBeans = new ConcurrentHashMap(5);
            attrs.put((CharSequence)SCOPED_BEANS_ATTRIBUTE, scopedBeans);
            return scopedBeans;
        }
        return null;
    }
}

