/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.Named;
import io.micronaut.inject.QualifiedBeanType;

@Internal
final class ServiceHttpClientCondition
implements Condition {
    ServiceHttpClientCondition() {
    }

    public boolean matches(ConditionContext context) {
        AnnotationMetadataProvider component = context.getComponent();
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext) {
            QualifiedBeanType qualifiedBeanType;
            Qualifier declaredQualifier;
            ApplicationContext applicationContext = (ApplicationContext)beanContext;
            if (component instanceof QualifiedBeanType && (declaredQualifier = (qualifiedBeanType = (QualifiedBeanType)component).getDeclaredQualifier()) instanceof Named) {
                Named named = (Named)declaredQualifier;
                String serviceName = named.getName();
                String urlProp = "micronaut.http.services." + serviceName + ".url";
                return applicationContext.containsProperty(urlProp) || applicationContext.containsProperty(urlProp + "s");
            }
        }
        return true;
    }
}

