/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.aop;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.lang.NonNullApi;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
@NonNullApi
@Incubating(since="1.0.0")
public class TimedAspect {
    private final MeterRegistry registry;
    private final Function<ProceedingJoinPoint, Iterable<Tag>> tagsBasedOnJoinPoint;

    public TimedAspect(MeterRegistry registry) {
        this(registry, pjp -> Tags.of("class", pjp.getStaticPart().getSignature().getDeclaringTypeName(), "method", pjp.getStaticPart().getSignature().getName()));
    }

    public TimedAspect(MeterRegistry registry, Function<ProceedingJoinPoint, Iterable<Tag>> tagsBasedOnJoinPoint) {
        this.registry = registry;
        this.tagsBasedOnJoinPoint = tagsBasedOnJoinPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution (@io.micrometer.core.annotation.Timed * *.*(..))")
    public Object timedMethod(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        Timed timed = method.getAnnotation(Timed.class);
        if (timed == null) {
            method = pjp.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
            timed = method.getAnnotation(Timed.class);
        }
        if (timed.value().isEmpty()) {
            return pjp.proceed();
        }
        Timer.Sample sample = Timer.start(this.registry);
        try {
            object = pjp.proceed();
        }
        catch (Throwable throwable) {
            try {
                sample.stop(Timer.builder(timed.value()).description(timed.description().isEmpty() ? null : timed.description()).tags(timed.extraTags()).tags(this.tagsBasedOnJoinPoint.apply(pjp)).publishPercentileHistogram(timed.histogram()).publishPercentiles(timed.percentiles().length == 0 ? null : timed.percentiles()).register(this.registry));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            sample.stop(Timer.builder(timed.value()).description(timed.description().isEmpty() ? null : timed.description()).tags(timed.extraTags()).tags(this.tagsBasedOnJoinPoint.apply(pjp)).publishPercentileHistogram(timed.histogram()).publishPercentiles(timed.percentiles().length == 0 ? null : timed.percentiles()).register(this.registry));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }
}

