/*
 * Decompiled with CFR 0.152.
 */
package io.github.ningyu.jmeter.plugin.dubbo.sample;

import io.github.ningyu.jmeter.plugin.util.MD5Util;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.NotifyListener;

public class RegistryServerSync
implements NotifyListener,
Serializable {
    private static final long serialVersionUID = -1744756264793278229L;
    private static ConcurrentMap<String, RegistryServerSync> cache = new ConcurrentHashMap<String, RegistryServerSync>();
    public static final URL SUBSCRIBE = new URL("admin", NetUtils.getLocalHost(), 0, "", new String[]{"interface", "*", "group", "*", "version", "*", "classifier", "*", "category", "providers", "enabled", "*", "check", String.valueOf(false)});
    private final ConcurrentMap<String, ConcurrentMap<String, Map<String, URL>>> registryCache = new ConcurrentHashMap<String, ConcurrentMap<String, Map<String, URL>>>();
    private final ConcurrentHashMap<String, String> URL_IDS_MAPPER = new ConcurrentHashMap();

    public static RegistryServerSync get(String key) {
        RegistryServerSync sync = (RegistryServerSync)cache.get(key);
        if (sync == null) {
            cache.putIfAbsent(key, new RegistryServerSync());
            sync = (RegistryServerSync)cache.get(key);
        }
        return sync;
    }

    public ConcurrentMap<String, ConcurrentMap<String, Map<String, URL>>> getRegistryCache() {
        return this.registryCache;
    }

    public void notify(List<URL> urls) {
        Map services;
        String category;
        if (urls == null || urls.isEmpty()) {
            return;
        }
        HashMap categories = new HashMap();
        String interfaceName = null;
        for (URL uRL : urls) {
            String service;
            HashMap<String, URL> ids;
            category = uRL.getParameter("category", "providers");
            if ("empty".equalsIgnoreCase(uRL.getProtocol())) {
                services = (ConcurrentMap)this.registryCache.get(category);
                if (services == null) continue;
                String group = uRL.getParameter("group");
                String version = uRL.getParameter("version");
                if (!"*".equals(group) && !"*".equals(version)) {
                    services.remove(uRL.getServiceKey());
                    continue;
                }
                for (Map.Entry serviceEntry : services.entrySet()) {
                    String service2 = (String)serviceEntry.getKey();
                    if (!this.getInterface(service2).equals(uRL.getServiceInterface()) || !"*".equals(group) && !StringUtils.isEquals((String)group, (String)this.getGroup(service2)) || !"*".equals(version) && !StringUtils.isEquals((String)version, (String)this.getVersion(service2))) continue;
                    services.remove(service2);
                }
                continue;
            }
            if (StringUtils.isEmpty(interfaceName)) {
                interfaceName = uRL.getServiceInterface();
            }
            if ((services = (Map)categories.get(category)) == null) {
                services = new HashMap();
                categories.put(category, services);
            }
            if ((ids = (HashMap<String, URL>)services.get(service = uRL.getServiceKey())) == null) {
                ids = new HashMap<String, URL>();
                services.put(service, ids);
            }
            if (this.URL_IDS_MAPPER.containsKey(uRL.toFullString())) {
                ids.put(this.URL_IDS_MAPPER.get(uRL.toFullString()), uRL);
                continue;
            }
            String md5 = MD5Util.MD5_16bit(uRL.toFullString());
            ids.put(md5, uRL);
            this.URL_IDS_MAPPER.putIfAbsent(uRL.toFullString(), md5);
        }
        if (categories.size() == 0) {
            return;
        }
        for (Map.Entry entry : categories.entrySet()) {
            category = (String)entry.getKey();
            services = (ConcurrentMap)this.registryCache.get(category);
            if (services == null) {
                services = new ConcurrentHashMap();
                this.registryCache.put(category, (ConcurrentMap<String, Map<String, URL>>)services);
            } else {
                HashSet keys = new HashSet(services.keySet());
                for (String key : keys) {
                    if (!this.getInterface(key).equals(interfaceName) || ((Map)entry.getValue()).entrySet().contains(key)) continue;
                    services.remove(key);
                }
            }
            services.putAll((Map)entry.getValue());
        }
    }

    public String getInterface(String service) {
        if (service != null && service.length() > 0) {
            int i = service.indexOf(47);
            if (i >= 0) {
                service = service.substring(i + 1);
            }
            if ((i = service.lastIndexOf(58)) >= 0) {
                service = service.substring(0, i);
            }
        }
        return service;
    }

    public String getGroup(String service) {
        int i;
        if (service != null && service.length() > 0 && (i = service.indexOf(47)) >= 0) {
            return service.substring(0, i);
        }
        return null;
    }

    public String getVersion(String service) {
        int i;
        if (service != null && service.length() > 0 && (i = service.lastIndexOf(58)) >= 0) {
            return service.substring(i + 1);
        }
        return null;
    }
}

