package io.lettuce.core.pubsub.api.sync;

import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;

/**
 * Synchronous and thread-safe Redis PubSub API.
 *
 * @param <K> Key type.
 * @param <V> Value type.
 * @author Mark Paluch
 * @since 4.0
 */
public interface RedisPubSubCommands<K, V> extends RedisCommands<K, V> {

    /**
     * Listen for messages published to channels matching the given patterns.
     *
     * @param patterns the patterns
     */
    void psubscribe(K... patterns);

    /**
     * Stop listening for messages posted to channels matching the given patterns.
     *
     * @param patterns the patterns
     */
    void punsubscribe(K... patterns);

    /**
     * Listen for messages published to the given channels.
     *
     * @param channels the channels
     */
    void subscribe(K... channels);

    /**
     * Stop listening for messages posted to the given channels.
     *
     * @param channels the channels
     */
    void unsubscribe(K... channels);

    /**
     * Listen for messages published to the given shard channels.
     *
     * @param shardChannels the channels
     * @since 6.4
     */
    void ssubscribe(K... shardChannels);

    /**
     * Stop listening for messages posted to the given channels.
     *
     * @param shardChannels the channels
     * @since 6.4
     */
    void sunsubscribe(K... shardChannels);

    /**
     * @return the underlying connection.
     */
    StatefulRedisPubSubConnection<K, V> getStatefulConnection();

}
