/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.cache.DeltaFIFO;
import io.kubernetes.client.informer.exception.BadNotificationException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorListener<ApiType extends KubernetesObject>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ProcessorListener.class);
    private long resyncPeriod;
    private OffsetDateTime nextResync;
    private BlockingQueue<Notification> queue;
    private ResourceEventHandler<ApiType> handler;

    public ProcessorListener(ResourceEventHandler<ApiType> handler, long resyncPeriod) {
        this.resyncPeriod = resyncPeriod;
        this.handler = handler;
        this.queue = new LinkedBlockingQueue<Notification>();
        this.determineNextResync(OffsetDateTime.now());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block8: while (true) {
            while (true) {
                Notification notification;
                Notification obj;
                if ((obj = this.queue.take()) instanceof UpdateNotification) {
                    notification = (UpdateNotification)obj;
                    try {
                        this.handler.onUpdate((KubernetesObject)((UpdateNotification)notification).getOldObj(), (KubernetesObject)((UpdateNotification)notification).getNewObj());
                        continue block8;
                    }
                    catch (Throwable t) {
                        log.error("failed invoking UPDATE event handler: {}", t);
                        continue;
                    }
                }
                if (obj instanceof AddNotification) {
                    notification = (AddNotification)obj;
                    try {
                        this.handler.onAdd((KubernetesObject)((AddNotification)notification).getNewObj());
                        continue block8;
                    }
                    catch (Throwable t) {
                        log.error("failed invoking ADD event handler: {}", t);
                        continue;
                    }
                }
                if (!(obj instanceof DeleteNotification)) throw new BadNotificationException("unrecognized notification");
                Object deletedObj = ((DeleteNotification)obj).getOldObj();
                try {
                    if (deletedObj instanceof DeltaFIFO.DeletedFinalStateUnknown) {
                        this.handler.onDelete(((DeltaFIFO.DeletedFinalStateUnknown)deletedObj).getObj(), true);
                        continue block8;
                    }
                    this.handler.onDelete((KubernetesObject)deletedObj, false);
                    continue block8;
                }
                catch (Throwable t) {
                    log.error("failed invoking DELETE event handler: {}", t);
                    continue;
                }
                break;
            }
            continue;
            break;
        }
        catch (InterruptedException e) {
            log.error("processor interrupted: {}", (Throwable)e);
            return;
        }
    }

    public void add(Notification<ApiType> obj) {
        if (obj == null) {
            return;
        }
        this.queue.add(obj);
    }

    public void determineNextResync(OffsetDateTime now) {
        this.nextResync = now.plus(Duration.ofMillis(this.resyncPeriod));
    }

    public boolean shouldResync(OffsetDateTime now) {
        return this.resyncPeriod != 0L && (now.isAfter(this.nextResync) || now.equals(this.nextResync));
    }

    public static final class DeleteNotification<ApiType>
    extends Notification<ApiType> {
        private ApiType oldObj;

        public DeleteNotification(ApiType oldObj) {
            this.oldObj = oldObj;
        }

        ApiType getOldObj() {
            return this.oldObj;
        }
    }

    public static final class AddNotification<ApiType>
    extends Notification<ApiType> {
        private ApiType newObj;

        public AddNotification(ApiType newObj) {
            this.newObj = newObj;
        }

        ApiType getNewObj() {
            return this.newObj;
        }
    }

    public static final class UpdateNotification<ApiType>
    extends Notification<ApiType> {
        private ApiType oldObj;
        private ApiType newObj;

        public UpdateNotification(ApiType oldObj, ApiType newObj) {
            this.oldObj = oldObj;
            this.newObj = newObj;
        }

        ApiType getOldObj() {
            return this.oldObj;
        }

        ApiType getNewObj() {
            return this.newObj;
        }
    }

    public static class Notification<ApiType> {
    }
}

