/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A topology selector requirement is a selector that matches given label. This is an alpha feature and may change in the future.")
public class V1TopologySelectorLabelRequirement {
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="values")
    private List<String> values = new ArrayList<String>();

    public V1TopologySelectorLabelRequirement key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="The label key that the selector applies to.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public V1TopologySelectorLabelRequirement values(List<String> values) {
        this.values = values;
        return this;
    }

    public V1TopologySelectorLabelRequirement addValuesItem(String valuesItem) {
        this.values.add(valuesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of string values. One value must match the label to be selected. Each entry in Values is ORed.")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TopologySelectorLabelRequirement v1TopologySelectorLabelRequirement = (V1TopologySelectorLabelRequirement)o;
        return Objects.equals(this.key, v1TopologySelectorLabelRequirement.key) && Objects.equals(this.values, v1TopologySelectorLabelRequirement.values);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1TopologySelectorLabelRequirement {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

