/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1DaemonSetCondition;
import io.kubernetes.client.openapi.models.V1DaemonSetConditionBuilder;
import io.kubernetes.client.openapi.models.V1DaemonSetConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1DaemonSetStatus;
import io.kubernetes.client.openapi.models.V1DaemonSetStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class V1DaemonSetStatusFluentImpl<A extends V1DaemonSetStatusFluent<A>>
extends BaseFluent<A>
implements V1DaemonSetStatusFluent<A> {
    private Integer collisionCount;
    private List<V1DaemonSetConditionBuilder> conditions;
    private Integer currentNumberScheduled;
    private Integer desiredNumberScheduled;
    private Integer numberAvailable;
    private Integer numberMisscheduled;
    private Integer numberReady;
    private Integer numberUnavailable;
    private Long observedGeneration;
    private Integer updatedNumberScheduled;

    public V1DaemonSetStatusFluentImpl() {
    }

    public V1DaemonSetStatusFluentImpl(V1DaemonSetStatus instance) {
        this.withCollisionCount(instance.getCollisionCount());
        this.withConditions(instance.getConditions());
        this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
        this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
        this.withNumberAvailable(instance.getNumberAvailable());
        this.withNumberMisscheduled(instance.getNumberMisscheduled());
        this.withNumberReady(instance.getNumberReady());
        this.withNumberUnavailable(instance.getNumberUnavailable());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled());
    }

    @Override
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    @Override
    public A withCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return (A)this;
    }

    @Override
    public Boolean hasCollisionCount() {
        return this.collisionCount != null;
    }

    @Override
    public A addToConditions(int index, V1DaemonSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1DaemonSetConditionBuilder>();
        }
        V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1DaemonSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1DaemonSetConditionBuilder>();
        }
        V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1DaemonSetCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1DaemonSetConditionBuilder>();
        }
        for (V1DaemonSetCondition item : items) {
            V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1DaemonSetCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1DaemonSetConditionBuilder>();
        }
        for (V1DaemonSetCondition item : items) {
            V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1DaemonSetCondition ... items) {
        for (V1DaemonSetCondition item : items) {
            V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1DaemonSetCondition> items) {
        for (V1DaemonSetCondition item : items) {
            V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1DaemonSetConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1DaemonSetConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1DaemonSetConditionBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1DaemonSetCondition> getConditions() {
        return V1DaemonSetStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<V1DaemonSetCondition> buildConditions() {
        return V1DaemonSetStatusFluentImpl.build(this.conditions);
    }

    @Override
    public V1DaemonSetCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1DaemonSetCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1DaemonSetCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1DaemonSetCondition buildMatchingCondition(Predicate<V1DaemonSetConditionBuilder> predicate) {
        for (V1DaemonSetConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1DaemonSetConditionBuilder> predicate) {
        for (V1DaemonSetConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1DaemonSetCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<V1DaemonSetConditionBuilder>();
            for (V1DaemonSetCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1DaemonSetCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1DaemonSetCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1DaemonSetStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1DaemonSetStatusFluent.ConditionsNested<A> addNewConditionLike(V1DaemonSetCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1DaemonSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1DaemonSetCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1DaemonSetStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1DaemonSetStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1DaemonSetStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1DaemonSetStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1DaemonSetConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getCurrentNumberScheduled() {
        return this.currentNumberScheduled;
    }

    @Override
    public A withCurrentNumberScheduled(Integer currentNumberScheduled) {
        this.currentNumberScheduled = currentNumberScheduled;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentNumberScheduled() {
        return this.currentNumberScheduled != null;
    }

    @Override
    public Integer getDesiredNumberScheduled() {
        return this.desiredNumberScheduled;
    }

    @Override
    public A withDesiredNumberScheduled(Integer desiredNumberScheduled) {
        this.desiredNumberScheduled = desiredNumberScheduled;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredNumberScheduled() {
        return this.desiredNumberScheduled != null;
    }

    @Override
    public Integer getNumberAvailable() {
        return this.numberAvailable;
    }

    @Override
    public A withNumberAvailable(Integer numberAvailable) {
        this.numberAvailable = numberAvailable;
        return (A)this;
    }

    @Override
    public Boolean hasNumberAvailable() {
        return this.numberAvailable != null;
    }

    @Override
    public Integer getNumberMisscheduled() {
        return this.numberMisscheduled;
    }

    @Override
    public A withNumberMisscheduled(Integer numberMisscheduled) {
        this.numberMisscheduled = numberMisscheduled;
        return (A)this;
    }

    @Override
    public Boolean hasNumberMisscheduled() {
        return this.numberMisscheduled != null;
    }

    @Override
    public Integer getNumberReady() {
        return this.numberReady;
    }

    @Override
    public A withNumberReady(Integer numberReady) {
        this.numberReady = numberReady;
        return (A)this;
    }

    @Override
    public Boolean hasNumberReady() {
        return this.numberReady != null;
    }

    @Override
    public Integer getNumberUnavailable() {
        return this.numberUnavailable;
    }

    @Override
    public A withNumberUnavailable(Integer numberUnavailable) {
        this.numberUnavailable = numberUnavailable;
        return (A)this;
    }

    @Override
    public Boolean hasNumberUnavailable() {
        return this.numberUnavailable != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public Integer getUpdatedNumberScheduled() {
        return this.updatedNumberScheduled;
    }

    @Override
    public A withUpdatedNumberScheduled(Integer updatedNumberScheduled) {
        this.updatedNumberScheduled = updatedNumberScheduled;
        return (A)this;
    }

    @Override
    public Boolean hasUpdatedNumberScheduled() {
        return this.updatedNumberScheduled != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DaemonSetStatusFluentImpl that = (V1DaemonSetStatusFluentImpl)o;
        if (this.collisionCount != null ? !this.collisionCount.equals(that.collisionCount) : that.collisionCount != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentNumberScheduled != null ? !this.currentNumberScheduled.equals(that.currentNumberScheduled) : that.currentNumberScheduled != null) {
            return false;
        }
        if (this.desiredNumberScheduled != null ? !this.desiredNumberScheduled.equals(that.desiredNumberScheduled) : that.desiredNumberScheduled != null) {
            return false;
        }
        if (this.numberAvailable != null ? !this.numberAvailable.equals(that.numberAvailable) : that.numberAvailable != null) {
            return false;
        }
        if (this.numberMisscheduled != null ? !this.numberMisscheduled.equals(that.numberMisscheduled) : that.numberMisscheduled != null) {
            return false;
        }
        if (this.numberReady != null ? !this.numberReady.equals(that.numberReady) : that.numberReady != null) {
            return false;
        }
        if (this.numberUnavailable != null ? !this.numberUnavailable.equals(that.numberUnavailable) : that.numberUnavailable != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        return !(this.updatedNumberScheduled != null ? !this.updatedNumberScheduled.equals(that.updatedNumberScheduled) : that.updatedNumberScheduled != null);
    }

    public int hashCode() {
        return Objects.hash(this.collisionCount, this.conditions, this.currentNumberScheduled, this.desiredNumberScheduled, this.numberAvailable, this.numberMisscheduled, this.numberReady, this.numberUnavailable, this.observedGeneration, this.updatedNumberScheduled, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends V1DaemonSetConditionFluentImpl<V1DaemonSetStatusFluent.ConditionsNested<N>>
    implements V1DaemonSetStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final V1DaemonSetConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, V1DaemonSetCondition item) {
            this.index = index;
            this.builder = new V1DaemonSetConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1DaemonSetConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1DaemonSetStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

