/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jersey.client;

import io.helidon.jersey.client.ExecutorProvider;
import io.helidon.jersey.client.ScheduledExecutorProvider;
import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientBuilder;

@Priority(value=5100)
public class ClientBuilderListener
implements org.glassfish.jersey.client.spi.ClientBuilderListener {
    private static final String USE_CONTEXT_AWARE_EXEC_PROVIDER = "io.helidon.jersey.client.useContextAwareExecutorProvider";
    private static Boolean useProvider;

    public void onNewBuilder(ClientBuilder builder) {
        if (this.useContextAwareProvider()) {
            builder.register(ExecutorProvider.class);
            builder.register(ScheduledExecutorProvider.class);
        }
    }

    private boolean useContextAwareProvider() {
        if (useProvider == null) {
            useProvider = Boolean.parseBoolean(System.getProperty(USE_CONTEXT_AWARE_EXEC_PROVIDER, "true"));
        }
        return useProvider;
    }
}

