/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityReader;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.MediaSupport;
import io.helidon.http.media.jsonp.JsonpReader;
import io.helidon.http.media.jsonp.JsonpWriter;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriterFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JsonpSupport
implements MediaSupport {
    public static final GenericType<JsonObject> JSON_OBJECT_TYPE = GenericType.create(JsonObject.class);
    public static final GenericType<JsonArray> JSON_ARRAY_TYPE = GenericType.create(JsonArray.class);
    private static final JsonReaderFactory READER_FACTORY = Json.createReaderFactory(Map.of());
    private static final JsonWriterFactory WRITER_FACTORY = Json.createWriterFactory(Map.of());
    private final JsonpReader reader = new JsonpReader(READER_FACTORY);
    private final JsonpWriter writer = new JsonpWriter(WRITER_FACTORY);
    private final String name;

    private JsonpSupport(String name) {
        this.name = name;
    }

    public static MediaSupport create() {
        return new JsonpSupport("jsonp");
    }

    public static MediaSupport create(Config config) {
        return JsonpSupport.create(config, "jsonp");
    }

    public static MediaSupport create(Config config, String name) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(name);
        return new JsonpSupport(name);
    }

    public static <T extends JsonStructure> EntityWriter<T> serverResponseWriter() {
        return new JsonpWriter(WRITER_FACTORY);
    }

    public static <T extends JsonStructure> EntityReader<T> serverRequestReader() {
        return new JsonpReader(READER_FACTORY);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return "jsonp";
    }

    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        if (this.isSupportedType(type) && requestHeaders.contentType().map(it -> it.test(MediaTypes.APPLICATION_JSON)).orElse(true).booleanValue()) {
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, this::reader);
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        if (this.isSupportedType(type)) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, this::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        if (this.isSupportedType(type)) {
            List acceptedTypes = requestHeaders.acceptedTypes();
            if (acceptedTypes.isEmpty()) {
                return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, this::reader);
            }
            for (HttpMediaType acceptedType : acceptedTypes) {
                if (!acceptedType.test(MediaTypes.APPLICATION_JSON)) continue;
                return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, this::reader);
            }
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (this.isSupportedType(type)) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, this::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    boolean isSupportedType(GenericType<?> type) {
        return JsonStructure.class.isAssignableFrom(type.rawType());
    }

    <T> EntityReader<T> reader() {
        return this.reader;
    }

    <T> EntityWriter<T> writer() {
        return this.writer;
    }
}

