/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractNodeBuilderImpl;
import io.helidon.config.Config;
import io.helidon.config.ListNodeImpl;
import io.helidon.config.MergeableNode;
import io.helidon.config.ObjectNodeBuilderImpl;
import io.helidon.config.ValueNodeImpl;
import io.helidon.config.spi.ConfigNode;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class ObjectNodeImpl
extends AbstractMap<String, ConfigNode>
implements ConfigNode.ObjectNode,
MergeableNode {
    private final Map<String, ConfigNode> members;
    private final Function<String, String> resolveTokenFunction;
    private final String value;
    private String description;

    ObjectNodeImpl(Map<String, ConfigNode> members, Function<String, String> resolveTokenFunction) {
        this(members, resolveTokenFunction, null);
    }

    ObjectNodeImpl(Map<String, ConfigNode> members, Function<String, String> resolveTokenFunction, String value) {
        this.members = members;
        this.resolveTokenFunction = resolveTokenFunction;
        this.value = value;
    }

    public static ObjectNodeImpl wrap(ConfigNode.ObjectNode objectNode) {
        return ObjectNodeImpl.wrap(objectNode, Function.identity());
    }

    public static ObjectNodeImpl wrap(ConfigNode.ObjectNode objectNode, Function<String, String> resolveTokenFunction) {
        return ObjectNodeBuilderImpl.create(objectNode, resolveTokenFunction).value(objectNode.value()).build();
    }

    @Override
    public Set<Map.Entry<String, ConfigNode>> entrySet() {
        return this.members.entrySet();
    }

    static ConfigNode.ObjectNode create(Config config) {
        ConfigNode.ObjectNode.Builder root = ConfigNode.ObjectNode.builder();
        ObjectNodeImpl.addObjectNode(root, config);
        return root.build();
    }

    static void initDescription(ConfigNode node, String description) {
        switch (node.nodeType()) {
            case OBJECT: {
                ((ObjectNodeImpl)node).initDescription(description);
                break;
            }
            case LIST: {
                ((ListNodeImpl)node).initDescription(description);
                break;
            }
            case VALUE: {
                ((ValueNodeImpl)node).initDescription(description);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
            }
        }
    }

    @Override
    public MergeableNode merge(MergeableNode node) {
        switch (node.nodeType()) {
            case OBJECT: {
                return this.mergeWithObjectNode((ObjectNodeImpl)node);
            }
            case LIST: {
                return this.mergeWithListNode((ListNodeImpl)node);
            }
            case VALUE: {
                return this.mergeWithValueNode((ValueNodeImpl)node);
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }

    private static void addObjectNode(ConfigNode.ObjectNode.Builder parentBuilder, Config parent) {
        parent.asNodeList().ifPresent(it -> {
            for (Config child : it) {
                String escapedName = Config.Key.escapeName(child.name());
                switch (child.type()) {
                    case OBJECT: {
                        Object childBuilder = ConfigNode.ObjectNode.builder();
                        ObjectNodeImpl.addObjectNode((ConfigNode.ObjectNode.Builder)childBuilder, child);
                        parentBuilder.addObject(escapedName, childBuilder.build());
                        break;
                    }
                    case LIST: {
                        Object childBuilder = ConfigNode.ListNode.builder();
                        ObjectNodeImpl.addListNode((ConfigNode.ListNode.Builder)childBuilder, child);
                        parentBuilder.addList(escapedName, (ConfigNode.ListNode)childBuilder.build());
                        break;
                    }
                    case VALUE: {
                        parentBuilder.addValue(escapedName, child.asString().get());
                        break;
                    }
                }
            }
        });
    }

    private static void addListNode(ConfigNode.ListNode.Builder parentBuilder, Config parent) {
        parent.asNodeList().ifPresent(it -> {
            for (Config child : it) {
                switch (child.type()) {
                    case OBJECT: {
                        Object childBuilder = ConfigNode.ObjectNode.builder();
                        ObjectNodeImpl.addObjectNode((ConfigNode.ObjectNode.Builder)childBuilder, child);
                        parentBuilder.addObject(childBuilder.build());
                        break;
                    }
                    case LIST: {
                        Object childBuilder = ConfigNode.ListNode.builder();
                        ObjectNodeImpl.addListNode((ConfigNode.ListNode.Builder)childBuilder, child);
                        parentBuilder.addList((ConfigNode.ListNode)childBuilder.build());
                        break;
                    }
                    case VALUE: {
                        parentBuilder.addValue(child.asString().get());
                        break;
                    }
                }
            }
        });
    }

    private MergeableNode mergeWithValueNode(ValueNodeImpl node) {
        ObjectNodeBuilderImpl builder = ObjectNodeBuilderImpl.create(this.members, this.resolveTokenFunction);
        builder.value(node.value());
        return builder.build();
    }

    private MergeableNode mergeWithObjectNode(ObjectNodeImpl node) {
        ObjectNodeBuilderImpl builder = ObjectNodeBuilderImpl.create(this.members, this.resolveTokenFunction);
        node.forEach((name, member) -> builder.deepMerge(AbstractNodeBuilderImpl.MergingKey.of(name), AbstractNodeBuilderImpl.wrap(member)));
        node.value().or(this::value).ifPresent(builder::value);
        return builder.build();
    }

    private MergeableNode mergeWithListNode(ListNodeImpl node) {
        ObjectNodeBuilderImpl builder = ObjectNodeBuilderImpl.create(this.members, this.resolveTokenFunction);
        if (node.hasValue()) {
            builder.value(node.value());
        } else if (this.hasValue()) {
            builder.value(this.value);
        }
        AtomicInteger index = new AtomicInteger(0);
        node.forEach((? super T configNode) -> {
            int i = index.getAndIncrement();
            builder.merge(String.valueOf(i), (MergeableNode)configNode);
        });
        return builder.build();
    }

    @Override
    public String toString() {
        if (null == this.value) {
            return "ObjectNode[" + this.members.size() + "]" + super.toString();
        }
        return "ObjectNode(\"" + this.value + "\")[" + this.members.size() + "]" + super.toString();
    }

    public ObjectNodeImpl initDescription(String description) {
        this.description = description;
        this.members.values().forEach((? super T node) -> ObjectNodeImpl.initDescription(node, description));
        return this;
    }

    public String description() {
        return this.description;
    }

    @Override
    public boolean hasValue() {
        return null != this.value;
    }

    @Override
    public Optional<String> value() {
        return Optional.ofNullable(this.value);
    }
}

