/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.pki.Keys;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsClientAuth;
import io.helidon.common.tls.TlsConfigBlueprint;
import io.helidon.common.tls.TlsConfigDecorator;
import io.helidon.common.tls.TlsManager;
import io.helidon.common.tls.spi.TlsManagerProvider;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.common.tls.TlsConfigBlueprint")
public interface TlsConfig
extends TlsConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TlsConfig instance) {
        return (Builder)TlsConfig.builder().from(instance);
    }

    public static TlsConfig create(Config config) {
        return ((Builder)TlsConfig.builder().config(config)).buildPrototype();
    }

    public static TlsConfig create() {
        return TlsConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, TlsConfig>
    implements io.helidon.common.Builder<Builder, Tls> {
        private Builder() {
        }

        public TlsConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.TlsConfigImpl(this);
        }

        public Tls build() {
            return Tls.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends TlsConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<String> applicationProtocols = new ArrayList<String>();
        private final List<String> enabledCipherSuites = new ArrayList<String>();
        private final List<String> enabledProtocols = new ArrayList<String>();
        private final List<X509Certificate> privateKeyCertChain = new ArrayList<X509Certificate>();
        private final List<X509Certificate> trust = new ArrayList<X509Certificate>();
        private boolean enabled = true;
        private boolean managerDiscoverServices = false;
        private boolean trustAll = false;
        private Config config;
        private Duration sessionTimeout = Duration.parse("PT24H");
        private int sessionCacheSize = 20480;
        private PrivateKey privateKey;
        private SecureRandom secureRandom;
        private SSLContext sslContext;
        private SSLParameters sslParameters;
        private String endpointIdentificationAlgorithm = "HTTPS";
        private String internalKeystoreProvider;
        private String internalKeystoreType;
        private String keyManagerFactoryAlgorithm;
        private String keyManagerFactoryProvider;
        private String protocol = "TLS";
        private String provider;
        private String secureRandomAlgorithm;
        private String secureRandomProvider;
        private String trustManagerFactoryAlgorithm;
        private String trustManagerFactoryProvider;
        private TlsClientAuth clientAuth = TlsClientAuth.NONE;
        private TlsManager manager;

        protected BuilderBase() {
        }

        public BUILDER from(TlsConfig prototype) {
            this.sslContext(prototype.sslContext());
            this.privateKey(prototype.privateKey());
            this.addPrivateKeyCertChain(prototype.privateKeyCertChain());
            this.addTrust(prototype.trust());
            this.manager(prototype.manager());
            this.secureRandom(prototype.secureRandom());
            this.sslParameters(prototype.sslParameters());
            this.secureRandomProvider(prototype.secureRandomProvider());
            this.secureRandomAlgorithm(prototype.secureRandomAlgorithm());
            this.keyManagerFactoryAlgorithm(prototype.keyManagerFactoryAlgorithm());
            this.keyManagerFactoryProvider(prototype.keyManagerFactoryProvider());
            this.trustManagerFactoryAlgorithm(prototype.trustManagerFactoryAlgorithm());
            this.trustManagerFactoryProvider(prototype.trustManagerFactoryProvider());
            this.addApplicationProtocols(prototype.applicationProtocols());
            this.endpointIdentificationAlgorithm(prototype.endpointIdentificationAlgorithm());
            this.enabled(prototype.enabled());
            this.trustAll(prototype.trustAll());
            this.clientAuth(prototype.clientAuth());
            this.protocol(prototype.protocol());
            this.provider(prototype.provider());
            this.addEnabledCipherSuites(prototype.enabledCipherSuites());
            this.addEnabledProtocols(prototype.enabledProtocols());
            this.sessionCacheSize(prototype.sessionCacheSize());
            this.sessionTimeout(prototype.sessionTimeout());
            this.internalKeystoreType(prototype.internalKeystoreType());
            this.internalKeystoreProvider(prototype.internalKeystoreProvider());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.sslContext().ifPresent(this::sslContext);
            builder.privateKey().ifPresent(this::privateKey);
            this.addPrivateKeyCertChain(builder.privateKeyCertChain());
            this.addTrust(builder.trust());
            builder.manager().ifPresent(this::manager);
            builder.secureRandom().ifPresent(this::secureRandom);
            builder.sslParameters().ifPresent(this::sslParameters);
            builder.secureRandomProvider().ifPresent(this::secureRandomProvider);
            builder.secureRandomAlgorithm().ifPresent(this::secureRandomAlgorithm);
            builder.keyManagerFactoryAlgorithm().ifPresent(this::keyManagerFactoryAlgorithm);
            builder.keyManagerFactoryProvider().ifPresent(this::keyManagerFactoryProvider);
            builder.trustManagerFactoryAlgorithm().ifPresent(this::trustManagerFactoryAlgorithm);
            builder.trustManagerFactoryProvider().ifPresent(this::trustManagerFactoryProvider);
            this.addApplicationProtocols(builder.applicationProtocols());
            this.endpointIdentificationAlgorithm(builder.endpointIdentificationAlgorithm());
            this.enabled(builder.enabled());
            this.trustAll(builder.trustAll());
            this.clientAuth(builder.clientAuth());
            this.protocol(builder.protocol());
            builder.provider().ifPresent(this::provider);
            this.addEnabledCipherSuites(builder.enabledCipherSuites());
            this.addEnabledProtocols(builder.enabledProtocols());
            this.sessionCacheSize(builder.sessionCacheSize());
            this.sessionTimeout(builder.sessionTimeout());
            builder.internalKeystoreType().ifPresent(this::internalKeystoreType);
            builder.internalKeystoreProvider().ifPresent(this::internalKeystoreProvider);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("private-key").map(Keys::create).ifPresent(this::privateKey);
            config.get("private-key").map(Keys::create).ifPresent(this::privateKeyCertChain);
            config.get("trust").map(Keys::create).ifPresent(this::trust);
            config.get("secure-random-provider").as(String.class).ifPresent(this::secureRandomProvider);
            config.get("secure-random-algorithm").as(String.class).ifPresent(this::secureRandomAlgorithm);
            config.get("key-manager-factory-algorithm").as(String.class).ifPresent(this::keyManagerFactoryAlgorithm);
            config.get("trust-manager-factory-algorithm").as(String.class).ifPresent(this::trustManagerFactoryAlgorithm);
            config.get("endpoint-identification-algorithm").as(String.class).ifPresent(this::endpointIdentificationAlgorithm);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("trust-all").as(Boolean.class).ifPresent(this::trustAll);
            config.get("client-auth").as(TlsClientAuth.class).ifPresent(this::clientAuth);
            config.get("protocol").as(String.class).ifPresent(this::protocol);
            config.get("provider").as(String.class).ifPresent(this::provider);
            config.get("cipher-suite").asList(String.class).ifPresent(this::enabledCipherSuites);
            config.get("protocols").asList(String.class).ifPresent(this::enabledProtocols);
            config.get("internal-keystore-type").as(String.class).ifPresent(this::internalKeystoreType);
            config.get("internal-keystore-provider").as(String.class).ifPresent(this::internalKeystoreProvider);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSslContext() {
            this.sslContext = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sslContext(SSLContext sslContext) {
            Objects.requireNonNull(sslContext);
            this.sslContext = sslContext;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPrivateKey() {
            this.privateKey = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER privateKey(PrivateKey privateKey) {
            Objects.requireNonNull(privateKey);
            this.privateKey = privateKey;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER privateKey(Keys privateKeyConfig) {
            Objects.requireNonNull(privateKeyConfig);
            this.privateKey = TlsConfigBlueprint.createPrivateKey(privateKeyConfig).orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER privateKey(Consumer<Keys.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Keys.Builder builder = Keys.builder();
            consumer.accept(builder);
            this.privateKey(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER privateKeyCertChain(List<? extends X509Certificate> privateKeyCertChain) {
            Objects.requireNonNull(privateKeyCertChain);
            this.privateKeyCertChain.clear();
            this.privateKeyCertChain.addAll(privateKeyCertChain);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPrivateKeyCertChain(List<? extends X509Certificate> privateKeyCertChain) {
            Objects.requireNonNull(privateKeyCertChain);
            this.privateKeyCertChain.addAll(privateKeyCertChain);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER privateKeyCertChain(Keys privateKeyCertChainConfig) {
            Objects.requireNonNull(privateKeyCertChainConfig);
            this.privateKeyCertChain.clear();
            this.privateKeyCertChain.addAll(TlsConfigBlueprint.createPrivateKeyCertChain(privateKeyCertChainConfig));
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPrivateKeyCertChain(X509Certificate privateKeyCertChain) {
            Objects.requireNonNull(privateKeyCertChain);
            this.privateKeyCertChain.add(privateKeyCertChain);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER privateKeyCertChain(Consumer<Keys.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Keys.Builder builder = Keys.builder();
            consumer.accept(builder);
            this.privateKeyCertChain(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER trust(List<? extends X509Certificate> trust) {
            Objects.requireNonNull(trust);
            this.trust.clear();
            this.trust.addAll(trust);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTrust(List<? extends X509Certificate> trust) {
            Objects.requireNonNull(trust);
            this.trust.addAll(trust);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER trust(Keys trustConfig) {
            Objects.requireNonNull(trustConfig);
            this.trust.clear();
            this.trust.addAll(TlsConfigBlueprint.createTrust(trustConfig));
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTrust(X509Certificate trust) {
            Objects.requireNonNull(trust);
            this.trust.add(trust);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER trust(Consumer<Keys.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Keys.Builder builder = Keys.builder();
            consumer.accept(builder);
            this.trust(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER manager(TlsManager manager) {
            Objects.requireNonNull(manager);
            this.manager = manager;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSecureRandom() {
            this.secureRandom = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER secureRandom(SecureRandom secureRandom) {
            Objects.requireNonNull(secureRandom);
            this.secureRandom = secureRandom;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSslParameters() {
            this.sslParameters = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sslParameters(SSLParameters sslParameters) {
            Objects.requireNonNull(sslParameters);
            this.sslParameters = sslParameters;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSecureRandomProvider() {
            this.secureRandomProvider = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER secureRandomProvider(String secureRandomProvider) {
            Objects.requireNonNull(secureRandomProvider);
            this.secureRandomProvider = secureRandomProvider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSecureRandomAlgorithm() {
            this.secureRandomAlgorithm = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER secureRandomAlgorithm(String secureRandomAlgorithm) {
            Objects.requireNonNull(secureRandomAlgorithm);
            this.secureRandomAlgorithm = secureRandomAlgorithm;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearKeyManagerFactoryAlgorithm() {
            this.keyManagerFactoryAlgorithm = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
            Objects.requireNonNull(keyManagerFactoryAlgorithm);
            this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearKeyManagerFactoryProvider() {
            this.keyManagerFactoryProvider = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keyManagerFactoryProvider(String keyManagerFactoryProvider) {
            Objects.requireNonNull(keyManagerFactoryProvider);
            this.keyManagerFactoryProvider = keyManagerFactoryProvider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTrustManagerFactoryAlgorithm() {
            this.trustManagerFactoryAlgorithm = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER trustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
            Objects.requireNonNull(trustManagerFactoryAlgorithm);
            this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTrustManagerFactoryProvider() {
            this.trustManagerFactoryProvider = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER trustManagerFactoryProvider(String trustManagerFactoryProvider) {
            Objects.requireNonNull(trustManagerFactoryProvider);
            this.trustManagerFactoryProvider = trustManagerFactoryProvider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER applicationProtocols(List<? extends String> applicationProtocols) {
            Objects.requireNonNull(applicationProtocols);
            this.applicationProtocols.clear();
            this.applicationProtocols.addAll(applicationProtocols);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addApplicationProtocols(List<? extends String> applicationProtocols) {
            Objects.requireNonNull(applicationProtocols);
            this.applicationProtocols.addAll(applicationProtocols);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addApplicationProtocol(String applicationProtocol) {
            Objects.requireNonNull(applicationProtocol);
            this.applicationProtocols.add(applicationProtocol);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER endpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
            Objects.requireNonNull(endpointIdentificationAlgorithm);
            this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER trustAll(boolean trustAll) {
            this.trustAll = trustAll;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clientAuth(TlsClientAuth clientAuth) {
            Objects.requireNonNull(clientAuth);
            this.clientAuth = clientAuth;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER protocol(String protocol) {
            Objects.requireNonNull(protocol);
            this.protocol = protocol;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProvider() {
            this.provider = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER provider(String provider) {
            Objects.requireNonNull(provider);
            this.provider = provider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabledCipherSuites(List<? extends String> enabledCipherSuites) {
            Objects.requireNonNull(enabledCipherSuites);
            this.enabledCipherSuites.clear();
            this.enabledCipherSuites.addAll(enabledCipherSuites);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addEnabledCipherSuites(List<? extends String> enabledCipherSuites) {
            Objects.requireNonNull(enabledCipherSuites);
            this.enabledCipherSuites.addAll(enabledCipherSuites);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addEnabledCipherSuite(String enabledCipherSuite) {
            Objects.requireNonNull(enabledCipherSuite);
            this.enabledCipherSuites.add(enabledCipherSuite);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabledProtocols(List<? extends String> enabledProtocols) {
            Objects.requireNonNull(enabledProtocols);
            this.enabledProtocols.clear();
            this.enabledProtocols.addAll(enabledProtocols);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addEnabledProtocols(List<? extends String> enabledProtocols) {
            Objects.requireNonNull(enabledProtocols);
            this.enabledProtocols.addAll(enabledProtocols);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addEnabledProtocol(String enabledProtocol) {
            Objects.requireNonNull(enabledProtocol);
            this.enabledProtocols.add(enabledProtocol);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sessionCacheSize(int sessionCacheSize) {
            this.sessionCacheSize = sessionCacheSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sessionTimeout(Duration sessionTimeout) {
            Objects.requireNonNull(sessionTimeout);
            this.sessionTimeout = sessionTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInternalKeystoreType() {
            this.internalKeystoreType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER internalKeystoreType(String internalKeystoreType) {
            Objects.requireNonNull(internalKeystoreType);
            this.internalKeystoreType = internalKeystoreType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInternalKeystoreProvider() {
            this.internalKeystoreProvider = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER internalKeystoreProvider(String internalKeystoreProvider) {
            Objects.requireNonNull(internalKeystoreProvider);
            this.internalKeystoreProvider = internalKeystoreProvider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<SSLContext> sslContext() {
            return Optional.ofNullable(this.sslContext);
        }

        public Optional<PrivateKey> privateKey() {
            return Optional.ofNullable(this.privateKey);
        }

        public List<X509Certificate> privateKeyCertChain() {
            return this.privateKeyCertChain;
        }

        public List<X509Certificate> trust() {
            return this.trust;
        }

        public Optional<TlsManager> manager() {
            return Optional.ofNullable(this.manager);
        }

        public Optional<SecureRandom> secureRandom() {
            return Optional.ofNullable(this.secureRandom);
        }

        public Optional<SSLParameters> sslParameters() {
            return Optional.ofNullable(this.sslParameters);
        }

        public Optional<String> secureRandomProvider() {
            return Optional.ofNullable(this.secureRandomProvider);
        }

        public Optional<String> secureRandomAlgorithm() {
            return Optional.ofNullable(this.secureRandomAlgorithm);
        }

        public Optional<String> keyManagerFactoryAlgorithm() {
            return Optional.ofNullable(this.keyManagerFactoryAlgorithm);
        }

        public Optional<String> keyManagerFactoryProvider() {
            return Optional.ofNullable(this.keyManagerFactoryProvider);
        }

        public Optional<String> trustManagerFactoryAlgorithm() {
            return Optional.ofNullable(this.trustManagerFactoryAlgorithm);
        }

        public Optional<String> trustManagerFactoryProvider() {
            return Optional.ofNullable(this.trustManagerFactoryProvider);
        }

        public List<String> applicationProtocols() {
            return this.applicationProtocols;
        }

        public String endpointIdentificationAlgorithm() {
            return this.endpointIdentificationAlgorithm;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public boolean trustAll() {
            return this.trustAll;
        }

        public TlsClientAuth clientAuth() {
            return this.clientAuth;
        }

        public String protocol() {
            return this.protocol;
        }

        public Optional<String> provider() {
            return Optional.ofNullable(this.provider);
        }

        public List<String> enabledCipherSuites() {
            return this.enabledCipherSuites;
        }

        public List<String> enabledProtocols() {
            return this.enabledProtocols;
        }

        public int sessionCacheSize() {
            return this.sessionCacheSize;
        }

        public Duration sessionTimeout() {
            return this.sessionTimeout;
        }

        public Optional<String> internalKeystoreType() {
            return Optional.ofNullable(this.internalKeystoreType);
        }

        public Optional<String> internalKeystoreProvider() {
            return Optional.ofNullable(this.internalKeystoreProvider);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "TlsConfigBuilder{sslContext=" + String.valueOf(this.sslContext) + ",privateKey=" + String.valueOf(this.privateKey) + ",privateKeyCertChain=" + String.valueOf(this.privateKeyCertChain) + ",trust=" + String.valueOf(this.trust) + ",manager=" + String.valueOf(this.manager) + ",secureRandom=" + String.valueOf(this.secureRandom) + ",sslParameters=" + String.valueOf(this.sslParameters) + ",secureRandomProvider=" + this.secureRandomProvider + ",secureRandomAlgorithm=" + this.secureRandomAlgorithm + ",keyManagerFactoryAlgorithm=" + this.keyManagerFactoryAlgorithm + ",keyManagerFactoryProvider=" + this.keyManagerFactoryProvider + ",trustManagerFactoryAlgorithm=" + this.trustManagerFactoryAlgorithm + ",trustManagerFactoryProvider=" + this.trustManagerFactoryProvider + ",applicationProtocols=" + String.valueOf(this.applicationProtocols) + ",endpointIdentificationAlgorithm=" + this.endpointIdentificationAlgorithm + ",enabled=" + this.enabled + ",trustAll=" + this.trustAll + ",clientAuth=" + String.valueOf((Object)this.clientAuth) + ",protocol=" + this.protocol + ",provider=" + this.provider + ",enabledCipherSuites=" + String.valueOf(this.enabledCipherSuites) + ",enabledProtocols=" + String.valueOf(this.enabledProtocols) + ",sessionCacheSize=" + this.sessionCacheSize + ",sessionTimeout=" + String.valueOf(this.sessionTimeout) + ",internalKeystoreType=" + this.internalKeystoreType + ",internalKeystoreProvider=" + this.internalKeystoreProvider + "}";
        }

        protected void preBuildPrototype() {
            this.config = this.config == null ? Config.empty() : this.config;
            HelidonServiceLoader serviceLoader = HelidonServiceLoader.create(ServiceLoader.load(TlsManagerProvider.class));
            this.discoverService(this.config, "manager", serviceLoader, TlsManagerProvider.class, TlsManager.class, this.managerDiscoverServices, Optional.ofNullable(this.manager)).ifPresent(this::manager);
            new TlsConfigDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.manager == null) {
                collector.fatal(this.getClass(), "Property \"manager\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER sslContext(Optional<? extends SSLContext> sslContext) {
            Objects.requireNonNull(sslContext);
            this.sslContext = sslContext.map(SSLContext.class::cast).orElse(this.sslContext);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER privateKey(Optional<? extends PrivateKey> privateKey) {
            Objects.requireNonNull(privateKey);
            this.privateKey = privateKey.map(PrivateKey.class::cast).orElse(this.privateKey);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER secureRandom(Optional<? extends SecureRandom> secureRandom) {
            Objects.requireNonNull(secureRandom);
            this.secureRandom = secureRandom.map(SecureRandom.class::cast).orElse(this.secureRandom);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER sslParameters(Optional<? extends SSLParameters> sslParameters) {
            Objects.requireNonNull(sslParameters);
            this.sslParameters = sslParameters.map(SSLParameters.class::cast).orElse(this.sslParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER secureRandomProvider(Optional<String> secureRandomProvider) {
            Objects.requireNonNull(secureRandomProvider);
            this.secureRandomProvider = secureRandomProvider.map(String.class::cast).orElse(this.secureRandomProvider);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER secureRandomAlgorithm(Optional<String> secureRandomAlgorithm) {
            Objects.requireNonNull(secureRandomAlgorithm);
            this.secureRandomAlgorithm = secureRandomAlgorithm.map(String.class::cast).orElse(this.secureRandomAlgorithm);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER keyManagerFactoryAlgorithm(Optional<String> keyManagerFactoryAlgorithm) {
            Objects.requireNonNull(keyManagerFactoryAlgorithm);
            this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm.map(String.class::cast).orElse(this.keyManagerFactoryAlgorithm);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER keyManagerFactoryProvider(Optional<String> keyManagerFactoryProvider) {
            Objects.requireNonNull(keyManagerFactoryProvider);
            this.keyManagerFactoryProvider = keyManagerFactoryProvider.map(String.class::cast).orElse(this.keyManagerFactoryProvider);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER trustManagerFactoryAlgorithm(Optional<String> trustManagerFactoryAlgorithm) {
            Objects.requireNonNull(trustManagerFactoryAlgorithm);
            this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm.map(String.class::cast).orElse(this.trustManagerFactoryAlgorithm);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER trustManagerFactoryProvider(Optional<String> trustManagerFactoryProvider) {
            Objects.requireNonNull(trustManagerFactoryProvider);
            this.trustManagerFactoryProvider = trustManagerFactoryProvider.map(String.class::cast).orElse(this.trustManagerFactoryProvider);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER provider(Optional<String> provider) {
            Objects.requireNonNull(provider);
            this.provider = provider.map(String.class::cast).orElse(this.provider);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER internalKeystoreType(Optional<String> internalKeystoreType) {
            Objects.requireNonNull(internalKeystoreType);
            this.internalKeystoreType = internalKeystoreType.map(String.class::cast).orElse(this.internalKeystoreType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER internalKeystoreProvider(Optional<String> internalKeystoreProvider) {
            Objects.requireNonNull(internalKeystoreProvider);
            this.internalKeystoreProvider = internalKeystoreProvider.map(String.class::cast).orElse(this.internalKeystoreProvider);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class TlsConfigImpl
        implements TlsConfig,
        Supplier<Tls> {
            private final boolean enabled;
            private final boolean trustAll;
            private final Duration sessionTimeout;
            private final int sessionCacheSize;
            private final List<String> applicationProtocols;
            private final List<String> enabledCipherSuites;
            private final List<String> enabledProtocols;
            private final List<X509Certificate> privateKeyCertChain;
            private final List<X509Certificate> trust;
            private final Optional<String> internalKeystoreProvider;
            private final Optional<String> internalKeystoreType;
            private final Optional<String> keyManagerFactoryAlgorithm;
            private final Optional<String> keyManagerFactoryProvider;
            private final Optional<String> provider;
            private final Optional<String> secureRandomAlgorithm;
            private final Optional<String> secureRandomProvider;
            private final Optional<String> trustManagerFactoryAlgorithm;
            private final Optional<String> trustManagerFactoryProvider;
            private final Optional<PrivateKey> privateKey;
            private final Optional<SecureRandom> secureRandom;
            private final Optional<SSLContext> sslContext;
            private final Optional<SSLParameters> sslParameters;
            private final String endpointIdentificationAlgorithm;
            private final String protocol;
            private final TlsClientAuth clientAuth;
            private final TlsManager manager;

            protected TlsConfigImpl(BuilderBase<?, ?> builder) {
                this.sslContext = builder.sslContext();
                this.privateKey = builder.privateKey();
                this.privateKeyCertChain = List.copyOf(builder.privateKeyCertChain());
                this.trust = List.copyOf(builder.trust());
                this.manager = builder.manager().get();
                this.secureRandom = builder.secureRandom();
                this.sslParameters = builder.sslParameters();
                this.secureRandomProvider = builder.secureRandomProvider();
                this.secureRandomAlgorithm = builder.secureRandomAlgorithm();
                this.keyManagerFactoryAlgorithm = builder.keyManagerFactoryAlgorithm();
                this.keyManagerFactoryProvider = builder.keyManagerFactoryProvider();
                this.trustManagerFactoryAlgorithm = builder.trustManagerFactoryAlgorithm();
                this.trustManagerFactoryProvider = builder.trustManagerFactoryProvider();
                this.applicationProtocols = List.copyOf(builder.applicationProtocols());
                this.endpointIdentificationAlgorithm = builder.endpointIdentificationAlgorithm();
                this.enabled = builder.enabled();
                this.trustAll = builder.trustAll();
                this.clientAuth = builder.clientAuth();
                this.protocol = builder.protocol();
                this.provider = builder.provider();
                this.enabledCipherSuites = List.copyOf(builder.enabledCipherSuites());
                this.enabledProtocols = List.copyOf(builder.enabledProtocols());
                this.sessionCacheSize = builder.sessionCacheSize();
                this.sessionTimeout = builder.sessionTimeout();
                this.internalKeystoreType = builder.internalKeystoreType();
                this.internalKeystoreProvider = builder.internalKeystoreProvider();
            }

            public Tls build() {
                return Tls.create(this);
            }

            @Override
            public Tls get() {
                return this.build();
            }

            @Override
            public Optional<SSLContext> sslContext() {
                return this.sslContext;
            }

            @Override
            public Optional<PrivateKey> privateKey() {
                return this.privateKey;
            }

            @Override
            public List<X509Certificate> privateKeyCertChain() {
                return this.privateKeyCertChain;
            }

            @Override
            public List<X509Certificate> trust() {
                return this.trust;
            }

            @Override
            public TlsManager manager() {
                return this.manager;
            }

            @Override
            public Optional<SecureRandom> secureRandom() {
                return this.secureRandom;
            }

            @Override
            public Optional<SSLParameters> sslParameters() {
                return this.sslParameters;
            }

            @Override
            public Optional<String> secureRandomProvider() {
                return this.secureRandomProvider;
            }

            @Override
            public Optional<String> secureRandomAlgorithm() {
                return this.secureRandomAlgorithm;
            }

            @Override
            public Optional<String> keyManagerFactoryAlgorithm() {
                return this.keyManagerFactoryAlgorithm;
            }

            @Override
            public Optional<String> keyManagerFactoryProvider() {
                return this.keyManagerFactoryProvider;
            }

            @Override
            public Optional<String> trustManagerFactoryAlgorithm() {
                return this.trustManagerFactoryAlgorithm;
            }

            @Override
            public Optional<String> trustManagerFactoryProvider() {
                return this.trustManagerFactoryProvider;
            }

            @Override
            public List<String> applicationProtocols() {
                return this.applicationProtocols;
            }

            @Override
            public String endpointIdentificationAlgorithm() {
                return this.endpointIdentificationAlgorithm;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public boolean trustAll() {
                return this.trustAll;
            }

            @Override
            public TlsClientAuth clientAuth() {
                return this.clientAuth;
            }

            @Override
            public String protocol() {
                return this.protocol;
            }

            @Override
            public Optional<String> provider() {
                return this.provider;
            }

            @Override
            public List<String> enabledCipherSuites() {
                return this.enabledCipherSuites;
            }

            @Override
            public List<String> enabledProtocols() {
                return this.enabledProtocols;
            }

            @Override
            public int sessionCacheSize() {
                return this.sessionCacheSize;
            }

            @Override
            public Duration sessionTimeout() {
                return this.sessionTimeout;
            }

            @Override
            public Optional<String> internalKeystoreType() {
                return this.internalKeystoreType;
            }

            @Override
            public Optional<String> internalKeystoreProvider() {
                return this.internalKeystoreProvider;
            }

            public String toString() {
                return "TlsConfig{sslContext=" + String.valueOf(this.sslContext) + ",privateKey=" + String.valueOf(this.privateKey) + ",privateKeyCertChain=" + String.valueOf(this.privateKeyCertChain) + ",trust=" + String.valueOf(this.trust) + ",manager=" + String.valueOf(this.manager) + ",secureRandom=" + String.valueOf(this.secureRandom) + ",sslParameters=" + String.valueOf(this.sslParameters) + ",secureRandomProvider=" + String.valueOf(this.secureRandomProvider) + ",secureRandomAlgorithm=" + String.valueOf(this.secureRandomAlgorithm) + ",keyManagerFactoryAlgorithm=" + String.valueOf(this.keyManagerFactoryAlgorithm) + ",keyManagerFactoryProvider=" + String.valueOf(this.keyManagerFactoryProvider) + ",trustManagerFactoryAlgorithm=" + String.valueOf(this.trustManagerFactoryAlgorithm) + ",trustManagerFactoryProvider=" + String.valueOf(this.trustManagerFactoryProvider) + ",applicationProtocols=" + String.valueOf(this.applicationProtocols) + ",endpointIdentificationAlgorithm=" + this.endpointIdentificationAlgorithm + ",enabled=" + this.enabled + ",trustAll=" + this.trustAll + ",clientAuth=" + String.valueOf((Object)this.clientAuth) + ",protocol=" + this.protocol + ",provider=" + String.valueOf(this.provider) + ",enabledCipherSuites=" + String.valueOf(this.enabledCipherSuites) + ",enabledProtocols=" + String.valueOf(this.enabledProtocols) + ",sessionCacheSize=" + this.sessionCacheSize + ",sessionTimeout=" + String.valueOf(this.sessionTimeout) + ",internalKeystoreType=" + String.valueOf(this.internalKeystoreType) + ",internalKeystoreProvider=" + String.valueOf(this.internalKeystoreProvider) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TlsConfig)) {
                    return false;
                }
                TlsConfig other = (TlsConfig)o;
                return Objects.equals(this.sslContext, other.sslContext()) && Objects.equals(this.privateKey, other.privateKey()) && Objects.equals(this.privateKeyCertChain, other.privateKeyCertChain()) && Objects.equals(this.trust, other.trust()) && Objects.equals(this.manager, other.manager()) && Objects.equals(this.secureRandom, other.secureRandom()) && Objects.equals(this.sslParameters, other.sslParameters()) && Objects.equals(this.secureRandomProvider, other.secureRandomProvider()) && Objects.equals(this.secureRandomAlgorithm, other.secureRandomAlgorithm()) && Objects.equals(this.keyManagerFactoryAlgorithm, other.keyManagerFactoryAlgorithm()) && Objects.equals(this.keyManagerFactoryProvider, other.keyManagerFactoryProvider()) && Objects.equals(this.trustManagerFactoryAlgorithm, other.trustManagerFactoryAlgorithm()) && Objects.equals(this.trustManagerFactoryProvider, other.trustManagerFactoryProvider()) && Objects.equals(this.applicationProtocols, other.applicationProtocols()) && Objects.equals(this.endpointIdentificationAlgorithm, other.endpointIdentificationAlgorithm()) && this.enabled == other.enabled() && this.trustAll == other.trustAll() && Objects.equals((Object)this.clientAuth, (Object)other.clientAuth()) && Objects.equals(this.protocol, other.protocol()) && Objects.equals(this.provider, other.provider()) && Objects.equals(this.enabledCipherSuites, other.enabledCipherSuites()) && Objects.equals(this.enabledProtocols, other.enabledProtocols()) && this.sessionCacheSize == other.sessionCacheSize() && Objects.equals(this.sessionTimeout, other.sessionTimeout()) && Objects.equals(this.internalKeystoreType, other.internalKeystoreType()) && Objects.equals(this.internalKeystoreProvider, other.internalKeystoreProvider());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.sslContext, this.privateKey, this.privateKeyCertChain, this.trust, this.manager, this.secureRandom, this.sslParameters, this.secureRandomProvider, this.secureRandomAlgorithm, this.keyManagerFactoryAlgorithm, this.keyManagerFactoryProvider, this.trustManagerFactoryAlgorithm, this.trustManagerFactoryProvider, this.applicationProtocols, this.endpointIdentificationAlgorithm, this.enabled, this.trustAll, this.clientAuth, this.protocol, this.provider, this.enabledCipherSuites, this.enabledProtocols, this.sessionCacheSize, this.sessionTimeout, this.internalKeystoreType, this.internalKeystoreProvider});
            }
        }
    }
}

