/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls;

import io.helidon.common.LazyValue;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.common.tls.TlsManager;
import io.helidon.common.tls.TlsReloadableX509KeyManager;
import io.helidon.common.tls.TlsReloadableX509TrustManager;
import io.helidon.common.tls.TrustAllManagerFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class ConfiguredTlsManager
implements TlsManager {
    private static final LazyValue<SecureRandom> RANDOM = LazyValue.create(SecureRandom::new);
    private final String name;
    private final String type;
    private volatile X509KeyManager keyManager;
    private volatile TlsReloadableX509KeyManager reloadableKeyManager;
    private volatile X509TrustManager trustManager;
    private volatile TlsReloadableX509TrustManager reloadableTrustManager;
    private volatile SSLContext sslContext;

    ConfiguredTlsManager() {
        this("@default", "tls-manager");
    }

    protected ConfiguredTlsManager(String name, String type) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public void init(TlsConfig tlsConfig) {
        this.sslContext(tlsConfig);
    }

    @Override
    public void reload(Tls tls) {
        this.reload(tls.keyManager(), tls.trustManager());
    }

    @Override
    public Optional<X509KeyManager> keyManager() {
        return Optional.ofNullable(this.keyManager);
    }

    @Override
    public Optional<X509TrustManager> trustManager() {
        return Optional.ofNullable(this.trustManager);
    }

    protected void reload(Optional<X509KeyManager> keyManager, Optional<X509TrustManager> trustManager) {
        keyManager.ifPresent(this.reloadableKeyManager::reload);
        trustManager.ifPresent(this.reloadableTrustManager::reload);
    }

    protected void initSslContext(TlsConfig tlsConfig, SecureRandom secureRandom, KeyManager[] keyManagers, TrustManager[] trustManagers) {
        try {
            KeyManager[] km = keyManagers.length == 0 ? null : this.wrapX509KeyManagers(keyManagers);
            TrustManager[] tm = trustManagers.length == 0 ? null : this.wrapX509TrustManagers(trustManagers);
            SSLContext sslContext = tlsConfig.provider().isPresent() ? SSLContext.getInstance(tlsConfig.protocol(), tlsConfig.provider().get()) : SSLContext.getInstance(tlsConfig.protocol());
            sslContext.init(km, tm, secureRandom);
            SSLSessionContext serverSessionContext = sslContext.getServerSessionContext();
            if (serverSessionContext != null) {
                if (tlsConfig.sessionCacheSize() != 20480) {
                    serverSessionContext.setSessionCacheSize(tlsConfig.sessionCacheSize());
                }
                serverSessionContext.setSessionTimeout((int)tlsConfig.sessionTimeout().toSeconds());
            }
            this.sslContext = sslContext;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to create SSLContext", e);
        }
    }

    protected SecureRandom secureRandom(TlsConfig tlsConfig) {
        if (tlsConfig.secureRandom().isPresent()) {
            return tlsConfig.secureRandom().get();
        }
        try {
            if (tlsConfig.secureRandomAlgorithm().isPresent() && tlsConfig.secureRandomProvider().isEmpty()) {
                return SecureRandom.getInstance(tlsConfig.secureRandomAlgorithm().get());
            }
            if (tlsConfig.secureRandomProvider().isPresent()) {
                if (tlsConfig.secureRandomAlgorithm().isEmpty()) {
                    throw new IllegalArgumentException("Invalid configuration of secure random. Provider is configured to " + tlsConfig.secureRandomProvider().get() + ", but algorithm is not specified");
                }
                return SecureRandom.getInstance(tlsConfig.secureRandomAlgorithm().get(), tlsConfig.secureRandomProvider().get());
            }
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("invalid configuration for secure random, cannot create it", e);
        }
        return (SecureRandom)RANDOM.get();
    }

    protected KeyManagerFactory buildKmf(TlsConfig target, SecureRandom secureRandom, PrivateKey privateKey, Certificate[] certificates) {
        byte[] passwordBytes = new byte[64];
        secureRandom.nextBytes(passwordBytes);
        char[] password = Base64.getEncoder().encodeToString(passwordBytes).toCharArray();
        try {
            KeyStore ks = this.internalKeystore(target);
            ks.setKeyEntry("key", privateKey, password, certificates);
            KeyManagerFactory kmf = this.kmf(target);
            kmf.init(ks, password);
            return kmf;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException("Invalid configuration for key management factory, cannot create factory", e);
        }
    }

    protected KeyStore internalKeystore(TlsConfig tlsConfig) {
        try {
            String type = tlsConfig.internalKeystoreType().orElseGet(KeyStore::getDefaultType);
            KeyStore ks = tlsConfig.internalKeystoreProvider().isEmpty() ? KeyStore.getInstance(type) : KeyStore.getInstance(type, tlsConfig.internalKeystoreProvider().get());
            ks.load(null, null);
            return ks;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new IllegalArgumentException("Invalid configuration of internal keystores. Provider: " + String.valueOf(tlsConfig.internalKeystoreProvider()) + ", type: " + String.valueOf(tlsConfig.internalKeystoreType()), e);
        }
    }

    protected TrustManagerFactory createTmf(TlsConfig tlsConfig) {
        try {
            String algorithm = tlsConfig.trustManagerFactoryAlgorithm().orElseGet(TrustManagerFactory::getDefaultAlgorithm);
            if (tlsConfig.trustManagerFactoryProvider().isEmpty()) {
                return TrustManagerFactory.getInstance(algorithm);
            }
            return TrustManagerFactory.getInstance(algorithm, tlsConfig.trustManagerFactoryProvider().get());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalArgumentException("Invalid configuration of trust manager factory. Provider: " + String.valueOf(tlsConfig.trustManagerFactoryProvider()) + ", algorithm: " + String.valueOf(tlsConfig.trustManagerFactoryAlgorithm()), e);
        }
    }

    protected TrustManagerFactory trustAllTmf() {
        return new TrustAllManagerFactory();
    }

    private TrustManagerFactory initTmf(TlsConfig tlsConfig) throws KeyStoreException {
        KeyStore ks = this.internalKeystore(tlsConfig);
        int i = 1;
        for (X509Certificate cert : tlsConfig.trust()) {
            ks.setCertificateEntry(String.valueOf(i), cert);
            ++i;
        }
        TrustManagerFactory tmf = this.createTmf(tlsConfig);
        tmf.init(ks);
        return tmf;
    }

    private TrustManagerFactory tmf(TlsConfig tlsConfig) throws KeyStoreException {
        if (tlsConfig.trustAll()) {
            return this.trustAllTmf();
        }
        if (!tlsConfig.trust().isEmpty()) {
            return this.initTmf(tlsConfig);
        }
        return null;
    }

    private void sslContext(TlsConfig tlsConfig) {
        if (tlsConfig.sslContext().isPresent()) {
            this.sslContext = tlsConfig.sslContext().get();
            return;
        }
        try {
            SecureRandom secureRandom = this.secureRandom(tlsConfig);
            KeyManagerFactory kmf = tlsConfig.privateKey().map(pk -> this.buildKmf(tlsConfig, secureRandom, (PrivateKey)pk, tlsConfig.privateKeyCertChain().toArray(new Certificate[0]))).orElse(null);
            TrustManagerFactory tmf = this.tmf(tlsConfig);
            this.initSslContext(tlsConfig, secureRandom, kmf == null ? new KeyManager[]{} : kmf.getKeyManagers(), tmf == null ? new TrustManager[]{} : tmf.getTrustManagers());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to create SSLContext", e);
        }
    }

    private KeyManagerFactory kmf(TlsConfig tlsConfig) {
        try {
            String algorithm = tlsConfig.keyManagerFactoryAlgorithm().orElseGet(KeyManagerFactory::getDefaultAlgorithm);
            if (tlsConfig.keyManagerFactoryProvider().isPresent()) {
                return KeyManagerFactory.getInstance(algorithm, tlsConfig.keyManagerFactoryProvider().get());
            }
            return KeyManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalArgumentException("Invalid configuration of key manager factory. Provider: " + String.valueOf(tlsConfig.keyManagerFactoryProvider()) + ", algorithm: " + String.valueOf(tlsConfig.keyManagerFactoryAlgorithm()), e);
        }
    }

    private KeyManager[] wrapX509KeyManagers(KeyManager[] keyManagers) {
        KeyManager[] toReturn = new KeyManager[keyManagers.length];
        System.arraycopy(keyManagers, 0, toReturn, 0, toReturn.length);
        for (int i = 0; i < keyManagers.length; ++i) {
            X509KeyManager x509KeyManager;
            KeyManager keyManager = keyManagers[i];
            if (!(keyManager instanceof X509KeyManager)) continue;
            this.keyManager = x509KeyManager = (X509KeyManager)keyManager;
            this.reloadableKeyManager = TlsReloadableX509KeyManager.create(x509KeyManager);
            toReturn[i] = this.reloadableKeyManager;
            return toReturn;
        }
        this.reloadableKeyManager = new TlsReloadableX509KeyManager.NotReloadableKeyManager();
        return toReturn;
    }

    private TrustManager[] wrapX509TrustManagers(TrustManager[] trustManagers) {
        TrustManager[] toReturn = new TrustManager[trustManagers.length];
        System.arraycopy(trustManagers, 0, toReturn, 0, toReturn.length);
        for (int i = 0; i < trustManagers.length; ++i) {
            X509TrustManager x509TrustManager;
            TrustManager trustManager = trustManagers[i];
            if (!(trustManager instanceof X509TrustManager)) continue;
            this.trustManager = x509TrustManager = (X509TrustManager)trustManager;
            this.reloadableTrustManager = TlsReloadableX509TrustManager.create(x509TrustManager);
            toReturn[i] = this.reloadableTrustManager;
            return toReturn;
        }
        this.reloadableTrustManager = new TlsReloadableX509TrustManager.NotReloadableTrustManager();
        return toReturn;
    }
}

