/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;

final class SingleOnErrorResume<T>
extends CompletionSingle<T> {
    private final Single<T> source;
    private final Function<? super Throwable, ? extends T> fallbackFunction;

    SingleOnErrorResume(Single<T> source, Function<? super Throwable, ? extends T> fallbackFunction) {
        this.source = source;
        this.fallbackFunction = fallbackFunction;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new OnErrorResumeSubscriber<T>(subscriber, this.fallbackFunction));
    }

    static final class OnErrorResumeSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Flow.Subscriber<T> {
        private final Function<? super Throwable, ? extends T> fallbackFunction;
        private Flow.Subscription upstream;

        OnErrorResumeSubscriber(Flow.Subscriber<? super T> downstream, Function<? super Throwable, ? extends T> fallbackFunction) {
            super(downstream);
            this.fallbackFunction = fallbackFunction;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.subscribeSelf();
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            this.upstream = SubscriptionHelper.CANCELED;
            this.complete(item);
        }

        @Override
        public void onError(Throwable throwable) {
            T fallback;
            this.upstream = SubscriptionHelper.CANCELED;
            try {
                fallback = Objects.requireNonNull(this.fallbackFunction.apply(throwable), "The fallback function returned a null item");
            }
            catch (Throwable ex) {
                if (ex != throwable) {
                    ex.addSuppressed(throwable);
                }
                this.error(ex);
                return;
            }
            this.complete(fallback);
        }

        @Override
        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.complete();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

