/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.OptionalCompletionStage;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

class OptionalCompletionStageImpl<T>
implements OptionalCompletionStage<T> {
    private final CompletionStage<Optional<T>> originalStage;

    OptionalCompletionStageImpl(CompletionStage<Optional<T>> originalStag) {
        this.originalStage = originalStag;
    }

    @Override
    public OptionalCompletionStage<T> onEmpty(Runnable action) {
        this.originalStage.thenAccept((? super T original) -> {
            if (!original.isPresent()) {
                action.run();
            }
        });
        return this;
    }

    @Override
    public OptionalCompletionStage<T> onValue(Consumer<? super T> action) {
        this.originalStage.thenAccept((? super T original) -> original.ifPresent(action));
        return this;
    }

    @Override
    public <U> CompletionStage<U> thenApply(Function<? super Optional<T>, ? extends U> fn) {
        return this.originalStage.thenApply(fn);
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super Optional<T>, ? extends U> fn) {
        return this.originalStage.thenApplyAsync(fn);
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super Optional<T>, ? extends U> fn, Executor executor) {
        return this.originalStage.thenApplyAsync(fn, executor);
    }

    @Override
    public CompletionStage<Void> thenAccept(Consumer<? super Optional<T>> action) {
        return this.originalStage.thenAccept(action);
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super Optional<T>> action) {
        return this.originalStage.thenAcceptAsync(action);
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super Optional<T>> action, Executor executor) {
        return this.originalStage.thenAcceptAsync(action, executor);
    }

    @Override
    public CompletionStage<Void> thenRun(Runnable action) {
        return this.originalStage.thenRun(action);
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action) {
        return this.originalStage.thenRunAsync(action);
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.originalStage.thenRunAsync(action, executor);
    }

    @Override
    public <U, V> CompletionStage<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super Optional<T>, ? super U, ? extends V> fn) {
        return this.originalStage.thenCombine(other, fn);
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super Optional<T>, ? super U, ? extends V> fn) {
        return this.originalStage.thenCombineAsync(other, fn);
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super Optional<T>, ? super U, ? extends V> fn, Executor executor) {
        return this.originalStage.thenCombineAsync(other, fn, executor);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super Optional<T>, ? super U> action) {
        return this.originalStage.thenAcceptBoth(other, action);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super Optional<T>, ? super U> action) {
        return this.originalStage.thenAcceptBothAsync(other, action);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super Optional<T>, ? super U> action, Executor executor) {
        return this.originalStage.thenAcceptBothAsync(other, action, executor);
    }

    @Override
    public CompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.originalStage.runAfterBoth(other, action);
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.originalStage.runAfterBothAsync(other, action);
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.originalStage.runAfterBothAsync(other, action, executor);
    }

    @Override
    public <U> CompletionStage<U> applyToEither(CompletionStage<? extends Optional<T>> other, Function<? super Optional<T>, U> fn) {
        return this.originalStage.applyToEither(other, fn);
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends Optional<T>> other, Function<? super Optional<T>, U> fn) {
        return this.originalStage.applyToEitherAsync(other, fn);
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends Optional<T>> other, Function<? super Optional<T>, U> fn, Executor executor) {
        return this.originalStage.applyToEitherAsync(other, fn, executor);
    }

    @Override
    public CompletionStage<Void> acceptEither(CompletionStage<? extends Optional<T>> other, Consumer<? super Optional<T>> action) {
        return this.originalStage.acceptEither(other, action);
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends Optional<T>> other, Consumer<? super Optional<T>> action) {
        return this.originalStage.acceptEitherAsync(other, action);
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends Optional<T>> other, Consumer<? super Optional<T>> action, Executor executor) {
        return this.originalStage.acceptEitherAsync(other, action, executor);
    }

    @Override
    public CompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.originalStage.runAfterEither(other, action);
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.originalStage.runAfterEitherAsync(other, action);
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.originalStage.runAfterEitherAsync(other, action, executor);
    }

    @Override
    public <U> CompletionStage<U> thenCompose(Function<? super Optional<T>, ? extends CompletionStage<U>> fn) {
        return this.originalStage.thenCompose(fn);
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super Optional<T>, ? extends CompletionStage<U>> fn) {
        return this.originalStage.thenComposeAsync(fn);
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super Optional<T>, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.originalStage.thenComposeAsync(fn, executor);
    }

    @Override
    public CompletionStage<Optional<T>> exceptionally(Function<Throwable, ? extends Optional<T>> fn) {
        return this.originalStage.exceptionally(fn);
    }

    @Override
    public CompletionStage<Optional<T>> whenComplete(BiConsumer<? super Optional<T>, ? super Throwable> action) {
        return this.originalStage.whenComplete(action);
    }

    @Override
    public CompletionStage<Optional<T>> whenCompleteAsync(BiConsumer<? super Optional<T>, ? super Throwable> action) {
        return this.originalStage.whenCompleteAsync(action);
    }

    @Override
    public CompletionStage<Optional<T>> whenCompleteAsync(BiConsumer<? super Optional<T>, ? super Throwable> action, Executor executor) {
        return this.originalStage.whenCompleteAsync(action, executor);
    }

    @Override
    public <U> CompletionStage<U> handle(BiFunction<? super Optional<T>, Throwable, ? extends U> fn) {
        return this.originalStage.handle(fn);
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super Optional<T>, Throwable, ? extends U> fn) {
        return this.originalStage.handleAsync(fn);
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super Optional<T>, Throwable, ? extends U> fn, Executor executor) {
        return this.originalStage.handleAsync(fn, executor);
    }

    @Override
    public CompletableFuture<Optional<T>> toCompletableFuture() {
        return this.originalStage.toCompletableFuture();
    }
}

