/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.HalfSerializer;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class MultiTakeUntilPublisher<T, U>
implements Multi<T> {
    private final Multi<T> source;
    private final Flow.Publisher<U> other;

    MultiTakeUntilPublisher(Multi<T> source, Flow.Publisher<U> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        TakeUntilMainSubscriber<T> parent = new TakeUntilMainSubscriber<T>(subscriber);
        subscriber.onSubscribe(parent);
        this.other.subscribe(parent.other());
        this.source.subscribe(parent);
    }

    static final class TakeUntilMainSubscriber<T>
    extends AtomicInteger
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final AtomicLong requested;
        private final AtomicReference<Flow.Subscription> upstream;
        private final AtomicReference<Throwable> error;
        private final TakeUntilOtherSubscriber other;

        TakeUntilMainSubscriber(Flow.Subscriber<? super T> downstream) {
            this.downstream = downstream;
            this.requested = new AtomicLong();
            this.upstream = new AtomicReference();
            this.error = new AtomicReference();
            this.other = new TakeUntilOtherSubscriber(this);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, subscription);
        }

        @Override
        public void onNext(T item) {
            HalfSerializer.onNext(this.downstream, this, this.error, item);
        }

        @Override
        public void onError(Throwable throwable) {
            SubscriptionHelper.cancel(this.other);
            HalfSerializer.onError(this.downstream, this, this.error, throwable);
        }

        @Override
        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            HalfSerializer.onComplete(this.downstream, this, this.error);
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                SubscriptionHelper.cancel(this.upstream);
                this.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
            } else {
                SubscriptionHelper.deferredRequest(this.upstream, this.requested, n);
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel(this.other);
        }

        void otherComplete() {
            SubscriptionHelper.cancel(this.upstream);
            HalfSerializer.onComplete(this.downstream, this, this.error);
        }

        void otherError(Throwable throwable) {
            SubscriptionHelper.cancel(this.upstream);
            HalfSerializer.onError(this.downstream, this, this.error, throwable);
        }

        TakeUntilOtherSubscriber other() {
            return this.other;
        }

        static final class TakeUntilOtherSubscriber
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<Object> {
            private final TakeUntilMainSubscriber<?> parent;

            TakeUntilOtherSubscriber(TakeUntilMainSubscriber<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                if (SubscriptionHelper.setOnce(this, subscription)) {
                    subscription.request(Long.MAX_VALUE);
                }
            }

            @Override
            public void onNext(Object item) {
                SubscriptionHelper.cancel(this);
                this.parent.otherComplete();
            }

            @Override
            public void onError(Throwable throwable) {
                if (this.get() != SubscriptionHelper.CANCELED) {
                    this.lazySet(SubscriptionHelper.CANCELED);
                    this.parent.otherError(throwable);
                }
            }

            @Override
            public void onComplete() {
                if (this.get() != SubscriptionHelper.CANCELED) {
                    this.lazySet(SubscriptionHelper.CANCELED);
                    this.parent.otherComplete();
                }
            }
        }
    }
}

