/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;

final class MultiRangeLongPublisher
implements Multi<Long> {
    private final long start;
    private final long end;

    MultiRangeLongPublisher(long start, long end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Long> subscriber) {
        subscriber.onSubscribe(new RangeSubscription(subscriber, this.start, this.end));
    }

    static final class RangeSubscription
    extends AtomicLong
    implements Flow.Subscription {
        private final Flow.Subscriber<? super Long> downstream;
        private long index;
        private final long end;
        private volatile int canceled;
        private static final int CANCELED = 1;
        private static final int BAD_REQUEST = 2;

        RangeSubscription(Flow.Subscriber<? super Long> downstream, long index, long end) {
            this.downstream = downstream;
            this.index = index;
            this.end = end;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.canceled = 2;
                n = 1L;
            }
            if (SubscriptionHelper.addRequest(this, n) != 0L) {
                return;
            }
            long e = 0L;
            long i = this.index;
            long end = this.end;
            Flow.Subscriber<? super Long> downstream = this.downstream;
            while (true) {
                int c;
                if (i != end && e != n) {
                    c = this.canceled;
                    if (c != 0) {
                        if (c == 2) {
                            downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden."));
                        }
                        return;
                    }
                    downstream.onNext((Long)i);
                    ++e;
                    ++i;
                    continue;
                }
                if (i == end) {
                    c = this.canceled;
                    if (this.canceled == 0) {
                        downstream.onComplete();
                    }
                    return;
                }
                n = this.get();
                if (n != e) continue;
                this.index = i;
                if ((n = SubscriptionHelper.produced(this, n)) == 0L) break;
                e = 0L;
            }
        }

        @Override
        public void cancel() {
            this.canceled = 1;
        }
    }
}

