/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;

final class MultiIfEmptyPublisher<T>
implements Multi<T> {
    private final Multi<T> source;
    private final Runnable ifEmpty;

    MultiIfEmptyPublisher(Multi<T> source, Runnable ifEmpty) {
        this.source = source;
        this.ifEmpty = ifEmpty;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new IfEmptySubscriber<T>(subscriber, this.ifEmpty));
    }

    static final class IfEmptySubscriber<T>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final Runnable ifEmpty;
        private boolean empty;
        private Flow.Subscription upstream;

        IfEmptySubscriber(Flow.Subscriber<? super T> downstream, Runnable ifEmpty) {
            this.downstream = downstream;
            this.ifEmpty = ifEmpty;
            this.empty = true;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.empty = false;
                this.downstream.onNext(item);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                boolean e = this.empty;
                if (e) {
                    try {
                        this.ifEmpty.run();
                    }
                    catch (Throwable t) {
                        this.downstream.onError(t);
                        return;
                    }
                }
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELED;
        }
    }
}

