/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;

final class MultiFromIterable<T>
implements Multi<T> {
    private final Iterable<T> iterable;

    MultiFromIterable(Iterable<T> iterable) {
        Objects.requireNonNull(iterable, "iterable is null");
        this.iterable = iterable;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        boolean hasFirst;
        Iterator<T> iterator;
        Objects.requireNonNull(subscriber, "subscriber is null");
        try {
            iterator = this.iterable.iterator();
            hasFirst = iterator.hasNext();
        }
        catch (Throwable ex) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            subscriber.onError(ex);
            return;
        }
        if (!hasFirst) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            subscriber.onComplete();
            return;
        }
        subscriber.onSubscribe(new IteratorSubscription<T>(subscriber, iterator));
    }

    static final class IteratorSubscription<T>
    extends AtomicLong
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private Iterator<T> iterator;
        private volatile int canceled;
        static final int NORMAL_CANCEL = 1;
        static final int BAD_REQUEST = 2;

        IteratorSubscription(Flow.Subscriber<? super T> downstream, Iterator<T> iterator) {
            this.downstream = downstream;
            this.iterator = iterator;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.canceled = 2;
                n = 1L;
            }
            if (SubscriptionHelper.addRequest(this, n) != 0L) {
                return;
            }
            long emitted = 0L;
            Flow.Subscriber<T> downstream = this.downstream;
            while (true) {
                if (emitted != n) {
                    boolean hasNext;
                    T value;
                    int isCanceled = this.canceled;
                    if (isCanceled != 0) {
                        this.iterator = null;
                        if (isCanceled == 2) {
                            downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive request amount is forbidden"));
                        }
                        return;
                    }
                    try {
                        value = Objects.requireNonNull(this.iterator.next(), "The iterator returned a null value");
                    }
                    catch (Throwable ex) {
                        this.iterator = null;
                        this.canceled = 1;
                        downstream.onError(ex);
                        return;
                    }
                    if (this.canceled != 0) continue;
                    downstream.onNext(value);
                    if (this.canceled != 0) continue;
                    try {
                        hasNext = this.iterator.hasNext();
                    }
                    catch (Throwable ex) {
                        this.iterator = null;
                        this.canceled = 1;
                        downstream.onError(ex);
                        return;
                    }
                    if (this.canceled != 0) continue;
                    if (!hasNext) {
                        this.iterator = null;
                        downstream.onComplete();
                        return;
                    }
                    ++emitted;
                    continue;
                }
                n = this.get();
                if (n != emitted) continue;
                n = SubscriptionHelper.produced(this, emitted);
                if (n == 0L) {
                    return;
                }
                emitted = 0L;
            }
        }

        @Override
        public void cancel() {
            this.canceled = 1;
            this.request(1L);
        }
    }
}

