/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;

final class MultiFlatMapIterable<T, R>
implements Multi<R> {
    private final Multi<T> source;
    private final Function<? super T, ? extends Iterable<? extends R>> mapper;
    private final int prefetch;

    MultiFlatMapIterable(Multi<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        this.source.subscribe(new FlatMapIterableSubscriber<T, R>(subscriber, this.mapper, this.prefetch));
    }

    static final class FlatMapIterableSubscriber<T, R>
    extends AtomicInteger
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super R> downstream;
        private final Function<? super T, ? extends Iterable<? extends R>> mapper;
        private final int prefetch;
        private final AtomicLong requested;
        private final AtomicReferenceArray<T> queue;
        private final AtomicLong producerIndex;
        private final AtomicLong consumerIndex;
        private Flow.Subscription upstream;
        private long emitted;
        private volatile boolean upstreamDone;
        private Throwable error;
        private volatile boolean canceled;
        private Iterator<? extends R> currentIterator;
        private int upstreamConsumed;

        FlatMapIterableSubscriber(Flow.Subscriber<? super R> downstream, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.requested = new AtomicLong();
            this.queue = new AtomicReferenceArray(FlatMapIterableSubscriber.roundToPowerOfTwo(prefetch));
            this.producerIndex = new AtomicLong();
            this.consumerIndex = new AtomicLong();
        }

        static int roundToPowerOfTwo(int value) {
            return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
            subscription.request(this.prefetch);
        }

        @Override
        public void onNext(T item) {
            this.offer(item);
            this.drain();
        }

        @Override
        public void onError(Throwable throwable) {
            this.error = throwable;
            this.upstreamDone = true;
            this.upstream = SubscriptionHelper.CANCELED;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.upstreamDone = true;
            this.upstream = SubscriptionHelper.CANCELED;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden!"));
            } else {
                SubscriptionHelper.addRequest(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.canceled = true;
            this.upstream.cancel();
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Iterator<R> iterator = this.currentIterator;
            Flow.Subscriber<R> downstream = this.downstream;
            long e = this.emitted;
            int limit = this.prefetch - (this.prefetch >> 2);
            int missed = 1;
            block6: while (true) {
                if (this.canceled) {
                    iterator = null;
                    this.currentIterator = null;
                    this.clear();
                } else {
                    Throwable ex;
                    if (this.upstreamDone && (ex = this.error) != null) {
                        this.canceled = true;
                        downstream.onError(ex);
                        continue;
                    }
                    if (iterator == null) {
                        boolean empty;
                        boolean d = this.upstreamDone;
                        T item = this.poll();
                        boolean bl = empty = item == null;
                        if (d && empty) {
                            this.canceled = true;
                            downstream.onComplete();
                            return;
                        }
                        if (!empty) {
                            boolean hasNext;
                            int c = this.upstreamConsumed + 1;
                            if (c == limit) {
                                this.upstreamConsumed = 0;
                                this.upstream.request(limit);
                            } else {
                                this.upstreamConsumed = c;
                            }
                            try {
                                iterator = Objects.requireNonNull(this.mapper.apply(item).iterator(), "The Iterable returned a null iterator");
                                hasNext = iterator.hasNext();
                            }
                            catch (Throwable ex2) {
                                this.canceled = true;
                                this.upstream.cancel();
                                downstream.onError(ex2);
                                continue;
                            }
                            if (!hasNext) {
                                iterator = null;
                                continue;
                            }
                            this.currentIterator = iterator;
                        }
                    }
                    if (iterator != null) {
                        long r = this.requested.get();
                        while (e != r) {
                            boolean hasNext;
                            R result;
                            if (this.canceled) continue block6;
                            try {
                                result = Objects.requireNonNull(iterator.next(), "The iterator returned a null item");
                            }
                            catch (Throwable ex3) {
                                this.canceled = true;
                                this.upstream.cancel();
                                downstream.onError(ex3);
                                continue block6;
                            }
                            if (this.canceled) continue block6;
                            downstream.onNext(result);
                            ++e;
                            if (this.canceled) continue block6;
                            try {
                                hasNext = iterator.hasNext();
                            }
                            catch (Throwable ex4) {
                                this.canceled = true;
                                this.upstream.cancel();
                                downstream.onError(ex4);
                                continue block6;
                            }
                            if (this.canceled) continue block6;
                            if (hasNext) continue;
                            iterator = null;
                            this.currentIterator = null;
                            continue block6;
                        }
                    }
                }
                this.emitted = e;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void offer(T item) {
            AtomicReferenceArray<T> queue = this.queue;
            AtomicLong producerIndex = this.producerIndex;
            long pi = producerIndex.get();
            int mask = queue.length() - 1;
            int offset = (int)pi & mask;
            queue.lazySet(offset, item);
            producerIndex.lazySet(pi + 1L);
        }

        T poll() {
            int mask;
            AtomicReferenceArray<T> queue = this.queue;
            AtomicLong consumerIndex = this.consumerIndex;
            long ci = consumerIndex.get();
            int offset = (int)ci & (mask = queue.length() - 1);
            T item = queue.get(offset);
            if (item == null) {
                return null;
            }
            queue.lazySet(offset, null);
            consumerIndex.lazySet(ci + 1L);
            return item;
        }

        boolean isEmpty() {
            AtomicLong producerIndex = this.producerIndex;
            AtomicLong consumerIndex = this.consumerIndex;
            return producerIndex.get() == consumerIndex.get();
        }

        void clear() {
            while (this.poll() != null) {
            }
        }
    }
}

