/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Supplier;

final class MultiDefer<T>
implements Multi<T> {
    private final Supplier<? extends Flow.Publisher<? extends T>> supplier;

    MultiDefer(Supplier<? extends Flow.Publisher<? extends T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Flow.Publisher<? super T> publisher;
        try {
            publisher = Objects.requireNonNull(this.supplier.get(), "The supplier returned a null Flow.Publisher");
        }
        catch (Throwable ex) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            subscriber.onError(ex);
            return;
        }
        publisher.subscribe(subscriber);
    }
}

