/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Flow;

final class MultiConcatArray<T>
implements Multi<T> {
    private final Flow.Publisher<T>[] sources;

    MultiConcatArray(Flow.Publisher<T>[] sources) {
        this.sources = sources;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        ConcatArraySubscriber<T> parent = new ConcatArraySubscriber<T>(subscriber, this.sources);
        subscriber.onSubscribe(parent);
        parent.nextSource(parent.produced);
    }

    protected static final class ConcatArraySubscriber<T>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final Flow.Publisher<T>[] sources;
        private Flow.Subscription subscription;
        private int index;
        private long produced = -9223372036854775805L;
        private volatile long requested = -9223372036854775806L;
        private volatile long pending = 0L;
        private volatile long oldRequested = 0L;
        private volatile Thread lastThreadCompleting;
        private boolean redo;
        static final long BAD = Long.MIN_VALUE;
        static final long CANCEL = -9223372036854775807L;
        static final long SEE_OTHER = -9223372036854775806L;
        static final long INIT = -9223372036854775805L;
        static final VarHandle REQUESTED;
        static final VarHandle PENDING;
        static final VarHandle LASTTHREADCOMPLETING;

        ConcatArraySubscriber(Flow.Subscriber<? super T> downstream, Flow.Publisher<T>[] sources) {
            this.downstream = downstream;
            this.sources = sources;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            long p;
            ++this.produced;
            this.subscription = subscription;
            long oldProduced = this.produced;
            long oldR = this.oldRequested;
            long p0 = this.pending;
            if (p0 < 0L && oldR != -9223372036854775807L) {
                oldR = p0;
            }
            this.requested = oldR;
            if (oldR == -9223372036854775807L) {
                subscription.cancel();
                return;
            }
            if (oldR != oldProduced) {
                long req = ConcatArraySubscriber.unconsumed(oldR, oldProduced);
                subscription.request(req);
            }
            if ((p = this.claimPending()) != 0L) {
                this.updateRequest(p);
            }
        }

        @Override
        public void onNext(T item) {
            ++this.produced;
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            REQUESTED.setOpaque(this, -9223372036854775807L);
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            boolean sameThread;
            boolean again;
            Thread current = Thread.currentThread();
            if (LASTTHREADCOMPLETING.getOpaque(this) == current) {
                this.redo = true;
                return;
            }
            LASTTHREADCOMPLETING.setOpaque(this, current);
            VarHandle.storeStoreFence();
            do {
                this.redo = false;
                long r = REQUESTED.getAndSet(this, -9223372036854775806L);
                this.subscription = null;
                this.nextSource(r);
                again = this.redo;
                VarHandle.loadLoadFence();
                boolean bl = sameThread = LASTTHREADCOMPLETING.getOpaque(this) == current;
            } while (again && sameThread);
            if (sameThread) {
                LASTTHREADCOMPLETING.compareAndSet(this, current, null);
            }
        }

        protected void nextSource(long r) {
            if (r == -9223372036854775807L) {
                return;
            }
            if (this.index == this.sources.length) {
                this.downstream.onComplete();
                return;
            }
            Flow.Publisher<T> nextPub = this.sources[this.index++];
            this.oldRequested = r < -9223372036854775805L || r == Long.MAX_VALUE ? r : r + 1L;
            nextPub.subscribe(this);
        }

        protected static long unconsumed(long req, long produced) {
            if (req >= -9223372036854775805L && req < Long.MAX_VALUE) {
                req = produced < 0L && Long.MAX_VALUE + produced < req ? Long.MAX_VALUE : (req -= produced);
            }
            return req;
        }

        @Override
        public void request(long n) {
            this.updateRequest(n <= 0L ? Long.MIN_VALUE : n);
        }

        private long claimPending() {
            long p;
            do {
                if ((p = this.pending) == 0L) {
                    return 0L;
                }
                long r = this.requested;
                if (r >= -9223372036854775805L || r == Long.MIN_VALUE && p == -9223372036854775807L) continue;
                return 0L;
            } while (!PENDING.compareAndSet(this, p, p < 0L ? p : 0L));
            return p;
        }

        private long updatePending(long n) {
            long nextReq;
            long req;
            while (((req = this.pending) >= 0L || req == Long.MIN_VALUE && n == -9223372036854775807L) && !PENDING.compareAndSet(this, req, nextReq = n < 0L ? n : (Long.MAX_VALUE - n <= req ? Long.MAX_VALUE : req + n))) {
            }
            return this.claimPending();
        }

        private void updateRequest(long n) {
            Flow.Subscription sub;
            long nextReq;
            long req;
            do {
                req = this.requested;
                while (req < -9223372036854775805L && (req != Long.MIN_VALUE || n != -9223372036854775807L)) {
                    if (req != -9223372036854775806L) {
                        return;
                    }
                    if ((n = this.updatePending(n)) == 0L) {
                        return;
                    }
                    req = this.requested;
                }
                sub = this.subscription;
            } while (!REQUESTED.compareAndSet(this, req, nextReq = n < -9223372036854775805L ? n : (Long.MAX_VALUE - n <= req ? Long.MAX_VALUE : req + n)));
            if (nextReq < -9223372036854775805L) {
                sub = this.subscription;
                if (sub != null) {
                    if (nextReq == -9223372036854775807L) {
                        sub.cancel();
                    } else {
                        sub.request(Long.MIN_VALUE);
                    }
                }
                return;
            }
            if (nextReq != req) {
                sub.request(nextReq - req);
            }
        }

        @Override
        public void cancel() {
            this.updateRequest(-9223372036854775807L);
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                REQUESTED = lookup.findVarHandle(ConcatArraySubscriber.class, "requested", Long.TYPE);
                PENDING = lookup.findVarHandle(ConcatArraySubscriber.class, "pending", Long.TYPE);
                LASTTHREADCOMPLETING = lookup.findVarHandle(ConcatArraySubscriber.class, "lastThreadCompleting", Thread.class);
            }
            catch (Exception e) {
                throw new Error("Expected lookup to succeed", e);
            }
        }
    }
}

