/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.GenericType;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.mapper.BuiltInMappers;
import io.helidon.common.mapper.DefaultMapperProvider;
import io.helidon.common.mapper.GlobalManager;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManagerImpl;
import io.helidon.common.mapper.spi.MapperProvider;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;

public interface MapperManager {
    public static MapperManager global() {
        return GlobalManager.mapperManager();
    }

    public static void global(MapperManager manager) {
        GlobalManager.mapperManager(manager);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MapperManager create() {
        return MapperManager.builder().build();
    }

    public <SOURCE, TARGET> TARGET map(SOURCE var1, GenericType<SOURCE> var2, GenericType<TARGET> var3, String ... var4) throws MapperException;

    public <SOURCE, TARGET> TARGET map(SOURCE var1, Class<SOURCE> var2, Class<TARGET> var3, String ... var4) throws MapperException;

    public <SOURCE, TARGET> Optional<Mapper<SOURCE, TARGET>> mapper(GenericType<SOURCE> var1, GenericType<TARGET> var2, String ... var3);

    public static final class Builder
    implements io.helidon.common.Builder<Builder, MapperManager> {
        private HelidonServiceLoader.Builder<MapperProvider> providers = HelidonServiceLoader.builder(ServiceLoader.load(MapperProvider.class));
        private boolean useBuiltIn;
        private boolean builtInAdded;
        private boolean discoverServices = true;

        private Builder() {
        }

        public MapperManager build() {
            if (this.useBuiltIn && !this.builtInAdded) {
                this.providers.addService((Object)new BuiltInMappers(), 10.0);
                this.builtInAdded = true;
            }
            this.providers.addService((Object)new DefaultMapperProvider(), 0.0);
            this.providers.useSystemServiceLoader(this.discoverServices);
            return new MapperManagerImpl(this);
        }

        public Builder addMapperProvider(MapperProvider provider) {
            this.providers.addService((Object)provider);
            return this;
        }

        public Builder addMapperProvider(MapperProvider provider, int priority) {
            this.providers.addService((Object)provider, (double)priority);
            return this;
        }

        public <S, T> Builder addMapper(Mapper<S, T> mapper, Class<S> sourceType, Class<T> targetType, String ... qualifiers) {
            return this.addMapper(mapper, sourceType, targetType, 100.0, qualifiers);
        }

        public <S, T> Builder addMapper(Mapper<S, T> mapper, Class<S> sourceType, Class<T> targetType, double weight, String ... qualifiers) {
            Set<String> qualifierSet = Set.of(qualifiers);
            this.providers.addService((sourceClass, targetClass, qualifier) -> {
                if (sourceType == sourceClass && targetType == targetClass) {
                    if (qualifierSet.contains(qualifier)) {
                        return new MapperProvider.ProviderResponse(MapperProvider.Support.SUPPORTED, mapper);
                    }
                    return new MapperProvider.ProviderResponse(MapperProvider.Support.COMPATIBLE, mapper);
                }
                return MapperProvider.ProviderResponse.unsupported();
            }, weight);
            return this;
        }

        public <S, T> Builder addMapper(Mapper<S, T> mapper, GenericType<S> sourceType, GenericType<T> targetType, String ... qualifiers) {
            return this.addMapper(mapper, sourceType, targetType, 100.0, qualifiers);
        }

        public <S, T> Builder addMapper(final Mapper<S, T> mapper, final GenericType<S> sourceType, final GenericType<T> targetType, double weight, String ... qualifiers) {
            final Set<String> qualifierSet = Set.of(qualifiers);
            this.providers.addService((Object)new MapperProvider(){

                @Override
                public MapperProvider.ProviderResponse mapper(Class<?> sourceClass, Class<?> targetClass, String qualifier) {
                    return MapperProvider.ProviderResponse.unsupported();
                }

                @Override
                public MapperProvider.ProviderResponse mapper(GenericType<?> source, GenericType<?> target, String qualifier) {
                    if (sourceType.equals(source) && targetType.equals(target)) {
                        if (qualifierSet.contains(qualifier)) {
                            return new MapperProvider.ProviderResponse(MapperProvider.Support.SUPPORTED, mapper);
                        }
                        return new MapperProvider.ProviderResponse(MapperProvider.Support.COMPATIBLE, mapper);
                    }
                    return MapperProvider.ProviderResponse.unsupported();
                }
            }, weight);
            return this;
        }

        public Builder useBuiltIn(boolean useBuiltIn) {
            this.useBuiltIn = useBuiltIn;
            return this;
        }

        public Builder discoverServices(boolean discoverServices) {
            this.discoverServices = discoverServices;
            return this;
        }

        List<MapperProvider> mapperProviders() {
            return this.providers.build().asList();
        }
    }
}

