/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnCallNotPermittedEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnIgnoredErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnResetEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnStateTransitionEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnSuccessEvent;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerState;
import io.github.resilience4j.circuitbreaker.internal.ClosedState;
import io.github.resilience4j.circuitbreaker.internal.DisabledState;
import io.github.resilience4j.circuitbreaker.internal.ForcedOpenState;
import io.github.resilience4j.circuitbreaker.internal.HalfOpenState;
import io.github.resilience4j.circuitbreaker.internal.OpenState;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CircuitBreakerStateMachine
implements CircuitBreaker {
    private static final Logger LOG = LoggerFactory.getLogger(CircuitBreakerStateMachine.class);
    private final String name;
    private final AtomicReference<CircuitBreakerState> stateReference;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final CircuitBreakerEventProcessor eventProcessor;

    public CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig) {
        this.name = name;
        this.circuitBreakerConfig = circuitBreakerConfig;
        this.stateReference = new AtomicReference<ClosedState>(new ClosedState(this));
        this.eventProcessor = new CircuitBreakerEventProcessor();
    }

    public CircuitBreakerStateMachine(String name) {
        this(name, CircuitBreakerConfig.ofDefaults());
    }

    public CircuitBreakerStateMachine(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfig) {
        this(name, circuitBreakerConfig.get());
    }

    @Override
    public boolean isCallPermitted() {
        boolean callPermitted = this.stateReference.get().isCallPermitted();
        if (!callPermitted) {
            this.publishCallNotPermittedEvent();
        }
        return callPermitted;
    }

    @Override
    public void onError(long durationInNanos, Throwable throwable) {
        if (this.circuitBreakerConfig.getRecordFailurePredicate().test(throwable)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("CircuitBreaker '%s' recorded a failure:", this.name), throwable);
            }
            this.publishCircuitErrorEvent(this.name, durationInNanos, throwable);
            this.stateReference.get().onError(throwable);
        } else {
            this.publishCircuitIgnoredErrorEvent(this.name, durationInNanos, throwable);
        }
    }

    @Override
    public void onSuccess(long durationInNanos) {
        this.publishSuccessEvent(durationInNanos);
        this.stateReference.get().onSuccess();
    }

    @Override
    public CircuitBreaker.State getState() {
        return this.stateReference.get().getState();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    @Override
    public CircuitBreaker.Metrics getMetrics() {
        return this.stateReference.get().getMetrics();
    }

    public String toString() {
        return String.format("CircuitBreaker '%s'", this.name);
    }

    @Override
    public void reset() {
        CircuitBreakerState previousState = this.stateReference.getAndUpdate(currentState -> new ClosedState(this));
        if (previousState.getState() != CircuitBreaker.State.CLOSED) {
            this.publishStateTransitionEvent(CircuitBreaker.StateTransition.transitionBetween(previousState.getState(), CircuitBreaker.State.CLOSED));
        }
        this.publishResetEvent();
    }

    private void stateTransition(CircuitBreaker.State newState, Function<CircuitBreakerState, CircuitBreakerState> newStateGenerator) {
        CircuitBreakerState previousState = this.stateReference.getAndUpdate(currentState -> {
            if (currentState.getState() == newState) {
                return currentState;
            }
            return (CircuitBreakerState)newStateGenerator.apply((CircuitBreakerState)currentState);
        });
        if (previousState.getState() != newState) {
            this.publishStateTransitionEvent(CircuitBreaker.StateTransition.transitionBetween(previousState.getState(), newState));
        }
    }

    @Override
    public void transitionToDisabledState() {
        this.stateTransition(CircuitBreaker.State.DISABLED, currentState -> new DisabledState(this));
    }

    @Override
    public void transitionToForcedOpenState() {
        this.stateTransition(CircuitBreaker.State.FORCED_OPEN, currentState -> new ForcedOpenState(this));
    }

    @Override
    public void transitionToClosedState() {
        this.stateTransition(CircuitBreaker.State.CLOSED, currentState -> new ClosedState(this, currentState.getMetrics()));
    }

    @Override
    public void transitionToOpenState() {
        this.stateTransition(CircuitBreaker.State.OPEN, currentState -> new OpenState(this, currentState.getMetrics()));
    }

    @Override
    public void transitionToHalfOpenState() {
        this.stateTransition(CircuitBreaker.State.HALF_OPEN, currentState -> new HalfOpenState(this));
    }

    private boolean shouldPublishEvents(CircuitBreakerEvent event) {
        return this.stateReference.get().shouldPublishEvents(event);
    }

    private void publishEventIfPossible(CircuitBreakerEvent event) {
        if (this.shouldPublishEvents(event)) {
            if (this.eventProcessor.hasConsumers()) {
                LOG.debug(String.format("Event %s published: %s", new Object[]{event.getEventType(), event}));
                try {
                    this.eventProcessor.consumeEvent(event);
                }
                catch (Throwable t) {
                    LOG.warn(String.format("Failed to handle event %s", new Object[]{event.getEventType()}), t);
                }
            } else {
                LOG.debug(String.format("No Consumers: Event %s not published", new Object[]{event.getEventType()}));
            }
        } else {
            LOG.debug(String.format("Publishing not allowed: Event %s not published", new Object[]{event.getEventType()}));
        }
    }

    private void publishStateTransitionEvent(CircuitBreaker.StateTransition stateTransition) {
        CircuitBreakerOnStateTransitionEvent event = new CircuitBreakerOnStateTransitionEvent(this.name, stateTransition);
        this.publishEventIfPossible(event);
    }

    private void publishResetEvent() {
        CircuitBreakerOnResetEvent event = new CircuitBreakerOnResetEvent(this.name);
        this.publishEventIfPossible(event);
    }

    private void publishCallNotPermittedEvent() {
        CircuitBreakerOnCallNotPermittedEvent event = new CircuitBreakerOnCallNotPermittedEvent(this.name);
        this.publishEventIfPossible(event);
    }

    private void publishSuccessEvent(long durationInNanos) {
        CircuitBreakerOnSuccessEvent event = new CircuitBreakerOnSuccessEvent(this.name, Duration.ofNanos(durationInNanos));
        this.publishEventIfPossible(event);
    }

    private void publishCircuitErrorEvent(String name, long durationInNanos, Throwable throwable) {
        CircuitBreakerOnErrorEvent event = new CircuitBreakerOnErrorEvent(name, Duration.ofNanos(durationInNanos), throwable);
        this.publishEventIfPossible(event);
    }

    private void publishCircuitIgnoredErrorEvent(String name, long durationInNanos, Throwable throwable) {
        CircuitBreakerOnIgnoredErrorEvent event = new CircuitBreakerOnIgnoredErrorEvent(name, Duration.ofNanos(durationInNanos), throwable);
        this.publishEventIfPossible(event);
    }

    @Override
    public CircuitBreaker.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    private class CircuitBreakerEventProcessor
    extends EventProcessor<CircuitBreakerEvent>
    implements EventConsumer<CircuitBreakerEvent>,
    CircuitBreaker.EventPublisher {
        private CircuitBreakerEventProcessor() {
        }

        @Override
        public CircuitBreaker.EventPublisher onSuccess(EventConsumer<CircuitBreakerOnSuccessEvent> onSuccessEventConsumer) {
            this.registerConsumer(CircuitBreakerOnSuccessEvent.class, onSuccessEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onError(EventConsumer<CircuitBreakerOnErrorEvent> onErrorEventConsumer) {
            this.registerConsumer(CircuitBreakerOnErrorEvent.class, onErrorEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onStateTransition(EventConsumer<CircuitBreakerOnStateTransitionEvent> onStateTransitionEventConsumer) {
            this.registerConsumer(CircuitBreakerOnStateTransitionEvent.class, onStateTransitionEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onReset(EventConsumer<CircuitBreakerOnResetEvent> onResetEventConsumer) {
            this.registerConsumer(CircuitBreakerOnResetEvent.class, onResetEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onIgnoredError(EventConsumer<CircuitBreakerOnIgnoredErrorEvent> onIgnoredErrorEventConsumer) {
            this.registerConsumer(CircuitBreakerOnIgnoredErrorEvent.class, onIgnoredErrorEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onCallNotPermitted(EventConsumer<CircuitBreakerOnCallNotPermittedEvent> onCallNotPermittedEventConsumer) {
            this.registerConsumer(CircuitBreakerOnCallNotPermittedEvent.class, onCallNotPermittedEventConsumer);
            return this;
        }

        public void consumeEvent(CircuitBreakerEvent event) {
            super.processEvent((Object)event);
        }
    }
}

