/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.internal.RingBitSet;
import java.util.concurrent.atomic.LongAdder;

class CircuitBreakerMetrics
implements CircuitBreaker.Metrics {
    private final int ringBufferSize;
    private final RingBitSet ringBitSet;
    private final LongAdder numberOfNotPermittedCalls;

    CircuitBreakerMetrics(int ringBufferSize) {
        this(ringBufferSize, null);
    }

    CircuitBreakerMetrics(int ringBufferSize, RingBitSet sourceSet) {
        this.ringBufferSize = ringBufferSize;
        this.ringBitSet = sourceSet != null ? new RingBitSet(this.ringBufferSize, sourceSet) : new RingBitSet(this.ringBufferSize);
        this.numberOfNotPermittedCalls = new LongAdder();
    }

    public CircuitBreakerMetrics copy(int targetRingBufferSize) {
        return new CircuitBreakerMetrics(targetRingBufferSize, this.ringBitSet);
    }

    float onError() {
        int currentNumberOfFailedCalls = this.ringBitSet.setNextBit(true);
        return this.getFailureRate(currentNumberOfFailedCalls);
    }

    float onSuccess() {
        int currentNumberOfFailedCalls = this.ringBitSet.setNextBit(false);
        return this.getFailureRate(currentNumberOfFailedCalls);
    }

    void onCallNotPermitted() {
        this.numberOfNotPermittedCalls.increment();
    }

    @Override
    public float getFailureRate() {
        return this.getFailureRate(this.getNumberOfFailedCalls());
    }

    @Override
    public int getMaxNumberOfBufferedCalls() {
        return this.ringBufferSize;
    }

    @Override
    public int getNumberOfSuccessfulCalls() {
        return this.getNumberOfBufferedCalls() - this.getNumberOfFailedCalls();
    }

    @Override
    public int getNumberOfBufferedCalls() {
        return this.ringBitSet.length();
    }

    @Override
    public long getNumberOfNotPermittedCalls() {
        return this.numberOfNotPermittedCalls.sum();
    }

    @Override
    public int getNumberOfFailedCalls() {
        return this.ringBitSet.cardinality();
    }

    private float getFailureRate(int numberOfFailedCalls) {
        if (this.getNumberOfBufferedCalls() < this.ringBufferSize) {
            return -1.0f;
        }
        return (float)numberOfFailedCalls * 100.0f / (float)this.ringBufferSize;
    }
}

