/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.task;

import com.alibaba.nacos.api.naming.remote.request.AbstractFuzzyWatchNotifyRequest;
import com.alibaba.nacos.api.naming.remote.request.NamingFuzzyWatchChangeNotifyRequest;
import com.alibaba.nacos.api.remote.PushCallBack;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.push.v2.NoRequiredRetryException;
import com.alibaba.nacos.naming.push.v2.PushConfig;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchChangeNotifyTask;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchPushDelayTaskEngine;

public class FuzzyWatchChangeNotifyExecuteTask
extends AbstractExecuteTask {
    private final String serviceKey;
    private final String changedType;
    private String clientId;
    private final FuzzyWatchPushDelayTaskEngine delayTaskEngine;

    public FuzzyWatchChangeNotifyExecuteTask(FuzzyWatchPushDelayTaskEngine delayTaskEngine, String serviceKey, String changedType, String targetClient) {
        this.serviceKey = serviceKey;
        this.changedType = changedType;
        this.clientId = targetClient;
        this.delayTaskEngine = delayTaskEngine;
    }

    public void run() {
        this.delayTaskEngine.getPushExecutor().doFuzzyWatchNotifyPushWithCallBack(this.clientId, (AbstractFuzzyWatchNotifyRequest)new NamingFuzzyWatchChangeNotifyRequest(this.serviceKey, this.changedType), new FuzzyWatchChangeNotifyCallback(this.clientId, this.serviceKey, this.changedType));
    }

    private class FuzzyWatchChangeNotifyCallback
    implements PushCallBack {
        private final String clientId;
        private String serviceKey;
        private String changedType;

        private FuzzyWatchChangeNotifyCallback(String clientId, String serviceKey, String changedType) {
            this.clientId = clientId;
            this.serviceKey = serviceKey;
            this.changedType = changedType;
        }

        public long getTimeout() {
            return PushConfig.getInstance().getPushTaskTimeout();
        }

        public void onSuccess() {
            Loggers.PUSH.info("[fuzzy watch] change notify success ,clientId {}, serviceKey {] ,changedType {} ", new Object[]{this.clientId, this.clientId, this.changedType});
        }

        public void onFail(Throwable e) {
            Loggers.PUSH.warn("[fuzzy watch] change notify fail ,clientId {}, serviceKey {] ,changedType {} ", new Object[]{this.clientId, this.clientId, this.changedType, e});
            if (!(e instanceof NoRequiredRetryException)) {
                FuzzyWatchChangeNotifyTask fuzzyWatchChangeNotifyTask = new FuzzyWatchChangeNotifyTask(this.serviceKey, this.changedType, this.clientId, PushConfig.getInstance().getPushTaskRetryDelay());
                FuzzyWatchChangeNotifyExecuteTask.this.delayTaskEngine.addTask(FuzzyWatchPushDelayTaskEngine.getTaskKey((NacosTask)fuzzyWatchChangeNotifyTask), fuzzyWatchChangeNotifyTask);
            }
        }
    }
}

