/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.remote.PushCallBack;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.push.ClientInfo;
import com.alibaba.nacos.naming.remote.udp.AckEntry;
import com.alibaba.nacos.naming.remote.udp.UdpConnector;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UdpPushService {
    @Autowired
    private SwitchDomain switchDomain;
    private final UdpConnector udpConnector;

    public UdpPushService(UdpConnector udpConnector) {
        this.udpConnector = udpConnector;
    }

    public void pushDataWithoutCallback(Subscriber subscriber, ServiceInfo serviceInfo) {
        String serviceName = subscriber.getServiceName();
        try {
            Loggers.PUSH.info(serviceName + " is changed, add it to push queue.");
            AckEntry ackEntry = this.prepareAckEntry(subscriber, serviceInfo);
            Loggers.PUSH.info("serviceName: {} changed, schedule push for: {}, agent: {}, key: {}", new Object[]{serviceInfo, subscriber.getAddrStr(), subscriber.getAgent(), ackEntry == null ? null : ackEntry.getKey()});
            this.udpConnector.sendData(ackEntry);
        }
        catch (Exception e) {
            Loggers.PUSH.error("[NACOS-PUSH] failed to push serviceName: {} to client, error: {}", (Object)serviceName, (Object)e);
        }
    }

    public void pushDataWithCallback(Subscriber subscriber, ServiceInfo serviceInfo, PushCallBack pushCallBack) {
        String serviceName = subscriber.getServiceName();
        try {
            Loggers.PUSH.info(serviceName + " is changed, add it to push queue.");
            AckEntry ackEntry = this.prepareAckEntry(subscriber, serviceInfo);
            Loggers.PUSH.info("serviceName: {} changed, schedule push for: {}, agent: {}, key: {}", new Object[]{serviceInfo, subscriber.getAddrStr(), subscriber.getAgent(), ackEntry == null ? null : ackEntry.getKey()});
            this.udpConnector.sendDataWithCallback(ackEntry, pushCallBack);
        }
        catch (Exception e) {
            Loggers.PUSH.error("[NACOS-PUSH] failed to push serviceName: {} to client, error: {}", (Object)serviceName, (Object)e);
        }
    }

    private AckEntry prepareAckEntry(Subscriber subscriber, ServiceInfo serviceInfo) {
        InetSocketAddress socketAddress = new InetSocketAddress(subscriber.getIp(), subscriber.getPort());
        long lastRefTime = System.nanoTime();
        return UdpPushService.prepareAckEntry(socketAddress, UdpPushService.prepareHostsData(JacksonUtils.toJson((Object)serviceInfo)), lastRefTime);
    }

    private static AckEntry prepareAckEntry(InetSocketAddress socketAddress, Map<String, Object> data, long lastRefTime) {
        if (MapUtils.isEmpty(data)) {
            Loggers.PUSH.error("[NACOS-PUSH] pushing empty data for client is not allowed: {}", (Object)socketAddress);
            return null;
        }
        data.put("lastRefTime", lastRefTime);
        String dataStr = JacksonUtils.toJson(data);
        try {
            byte[] dataBytes = dataStr.getBytes(StandardCharsets.UTF_8);
            dataBytes = UdpPushService.compressIfNecessary(dataBytes);
            return UdpPushService.prepareAckEntry(socketAddress, dataBytes, data, lastRefTime);
        }
        catch (Exception e) {
            Loggers.PUSH.error("[NACOS-PUSH] failed to compress data: {} to client: {}, error: {}", new Object[]{data, socketAddress, e});
            return null;
        }
    }

    private static AckEntry prepareAckEntry(InetSocketAddress socketAddress, byte[] dataBytes, Map<String, Object> data, long lastRefTime) {
        String key = AckEntry.getAckKey(socketAddress.getAddress().getHostAddress(), socketAddress.getPort(), lastRefTime);
        try {
            DatagramPacket packet = new DatagramPacket(dataBytes, dataBytes.length, socketAddress);
            AckEntry ackEntry = new AckEntry(key, packet);
            ackEntry.setData(data);
            return ackEntry;
        }
        catch (Exception e) {
            Loggers.PUSH.error("[NACOS-PUSH] failed to prepare data: {} to client: {}, error: {}", new Object[]{data, socketAddress, e});
            return null;
        }
    }

    public boolean canEnablePush(String agent) {
        if (!this.switchDomain.isPushEnabled()) {
            return false;
        }
        ClientInfo clientInfo = new ClientInfo(agent);
        if (ClientInfo.ClientType.JAVA == clientInfo.type && clientInfo.version.compareTo(this.parseVersion(this.switchDomain.getPushVersionOfJava())) >= 0) {
            return true;
        }
        if (ClientInfo.ClientType.DNS == clientInfo.type && clientInfo.version.compareTo(this.parseVersion(this.switchDomain.getPushVersionOfPython())) >= 0) {
            return true;
        }
        if (ClientInfo.ClientType.C == clientInfo.type && clientInfo.version.compareTo(this.parseVersion(this.switchDomain.getPushVersionOfC())) >= 0) {
            return true;
        }
        if (ClientInfo.ClientType.GO == clientInfo.type && clientInfo.version.compareTo(this.parseVersion(this.switchDomain.getPushVersionOfGo())) >= 0) {
            return true;
        }
        return ClientInfo.ClientType.CSHARP == clientInfo.type && clientInfo.version.compareTo(this.parseVersion(this.switchDomain.getPushVersionOfCsharp())) >= 0;
    }

    private Version parseVersion(String version) {
        return VersionUtil.parseVersion((String)version, null, null);
    }

    private static byte[] compressIfNecessary(byte[] dataBytes) throws IOException {
        int maxDataSizeUncompress = 1024;
        if (dataBytes.length < maxDataSizeUncompress) {
            return dataBytes;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(dataBytes);
        gzip.close();
        return out.toByteArray();
    }

    private static Map<String, Object> prepareHostsData(String dataContent) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("type", "dom");
        result.put("data", dataContent);
        return result;
    }
}

