/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.monitor;

import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.core.monitor.NacosMeterRegistryCenter;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import io.micrometer.core.instrument.ImmutableTag;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class NamingDynamicMeterRefreshService {
    private static final String TOPN_SERVICE_CHANGE_REGISTRY = "TOPN_SERVICE_CHANGE_REGISTRY";
    private static final int SERVICE_CHANGE_N = 10;

    @Scheduled(cron="0/30 * * * * *")
    public void refreshTopnServiceChangeCount() {
        NacosMeterRegistryCenter.clear((String)TOPN_SERVICE_CHANGE_REGISTRY);
        List topnServiceChangeCount = MetricsMonitor.getServiceChangeCount().getCounterOfTopN(10);
        for (Pair serviceChangeCount : topnServiceChangeCount) {
            ArrayList<ImmutableTag> tags = new ArrayList<ImmutableTag>();
            tags.add(new ImmutableTag("service", (String)serviceChangeCount.getFirst()));
            NacosMeterRegistryCenter.gauge((String)TOPN_SERVICE_CHANGE_REGISTRY, (String)"service_change_count", tags, (Number)((AtomicInteger)serviceChangeCount.getSecond()));
        }
    }

    @Scheduled(cron="0 0 0 ? * 1")
    public void resetTopnServiceChangeCount() {
        MetricsMonitor.getServiceChangeCount().reset();
    }
}

