/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.model.form;

import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.NacosForm;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Objects;
import org.springframework.http.HttpStatus;

public class InstanceListForm
implements NacosForm {
    private static final long serialVersionUID = -3760300561436525429L;
    private String namespaceId;
    private String groupName;
    private String serviceName;
    private String clusterName;
    private Boolean healthyOnly;

    public void validate() throws NacosApiException {
        this.fillDefaultValue();
        if (StringUtils.isBlank((CharSequence)this.serviceName)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "Required parameter 'serviceName' type String is not present");
        }
    }

    public void fillDefaultValue() {
        if (StringUtils.isBlank((CharSequence)this.namespaceId)) {
            this.namespaceId = "public";
        }
        if (StringUtils.isBlank((CharSequence)this.groupName)) {
            this.groupName = "DEFAULT_GROUP";
        }
        if (StringUtils.isBlank((CharSequence)this.clusterName)) {
            this.clusterName = "DEFAULT";
        }
        if (null == this.healthyOnly) {
            this.healthyOnly = false;
        }
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public Boolean getHealthyOnly() {
        return this.healthyOnly;
    }

    public void setHealthyOnly(Boolean healthyOnly) {
        this.healthyOnly = healthyOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceListForm that = (InstanceListForm)o;
        return Objects.equals(this.namespaceId, that.namespaceId) && Objects.equals(this.groupName, that.groupName) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.healthyOnly, that.healthyOnly);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.groupName, this.serviceName, this.clusterName, this.healthyOnly);
    }
}

