/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.snapshot.LocalFileMeta;
import com.alibaba.nacos.consistency.snapshot.Reader;
import com.alibaba.nacos.consistency.snapshot.Writer;
import com.alibaba.nacos.naming.consistency.persistent.impl.AbstractSnapshotOperation;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchManager;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alipay.sofa.jraft.util.CRC64;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.Checksum;

public class SwitchDomainSnapshotOperation
extends AbstractSnapshotOperation {
    private final String snapshotDir = "naming_persistent";
    private final String snapshotArchive = "naming_persistent.zip";
    private final SwitchManager switchManager;
    private final Serializer serializer;

    public SwitchDomainSnapshotOperation(ReentrantReadWriteLock lock, SwitchManager switchManager, Serializer serializer) {
        super(lock);
        this.switchManager = switchManager;
        this.serializer = serializer;
    }

    @Override
    protected boolean writeSnapshot(Writer writer) throws Exception {
        String writePath = writer.getPath();
        String parentPath = Paths.get(writePath, "naming_persistent").toString();
        DiskUtils.deleteDirectory((String)parentPath);
        DiskUtils.forceMkdir((String)parentPath);
        this.switchManager.dumpSnapshot(parentPath);
        String outputFile = Paths.get(writePath, "naming_persistent.zip").toString();
        CRC64 checksum = new CRC64();
        DiskUtils.compress((String)writePath, (String)"naming_persistent", (String)outputFile, (Checksum)checksum);
        DiskUtils.deleteDirectory((String)parentPath);
        LocalFileMeta meta = new LocalFileMeta();
        meta.append((Object)"checksum", (Object)Long.toHexString(checksum.getValue()));
        return writer.addFile("naming_persistent.zip", meta);
    }

    @Override
    protected boolean readSnapshot(Reader reader) throws Exception {
        String readerPath = reader.getPath();
        String sourceFile = Paths.get(readerPath, "naming_persistent.zip").toString();
        CRC64 checksum = new CRC64();
        DiskUtils.decompress((String)sourceFile, (String)readerPath, (Checksum)checksum);
        LocalFileMeta fileMeta = reader.getFileMeta("naming_persistent.zip");
        if (fileMeta.getFileMeta().containsKey("checksum") && !Objects.equals(Long.toHexString(checksum.getValue()), fileMeta.get("checksum"))) {
            throw new IllegalArgumentException("Snapshot checksum failed");
        }
        String loadPath = Paths.get(readerPath, "naming_persistent").toString();
        Loggers.RAFT.info("snapshot load from : {}", (Object)loadPath);
        this.switchManager.loadSnapshot(loadPath);
        DiskUtils.deleteDirectory((String)loadPath);
        return true;
    }

    @Override
    protected String getSnapshotSaveTag() {
        return SwitchDomainSnapshotOperation.class.getSimpleName() + ".SAVE";
    }

    @Override
    protected String getSnapshotLoadTag() {
        return SwitchDomainSnapshotOperation.class.getSimpleName() + ".LOAD";
    }
}

