/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.client.factory;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.core.v2.client.factory.ClientFactory;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.Collection;
import java.util.HashMap;

public class ClientFactoryHolder {
    private static final ClientFactoryHolder INSTANCE = new ClientFactoryHolder();
    private final HashMap<String, ClientFactory> clientFactories = new HashMap(4);

    private ClientFactoryHolder() {
        Collection clientFactories = NacosServiceLoader.load(ClientFactory.class);
        for (ClientFactory each : clientFactories) {
            if (this.clientFactories.containsKey(each.getType())) {
                Loggers.SRV_LOG.warn("Client type {} found multiple factory, use {} default", (Object)each.getType(), (Object)each.getClass().getCanonicalName());
            }
            this.clientFactories.put(each.getType(), each);
        }
    }

    public static ClientFactoryHolder getInstance() {
        return INSTANCE;
    }

    public ClientFactory findClientFactory(String type) {
        if (StringUtils.isEmpty((String)type) || !this.clientFactories.containsKey(type)) {
            return this.clientFactories.get("default");
        }
        return this.clientFactories.get(type);
    }
}

