/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.common;

import com.alibaba.nacos.istio.common.NacosResourceManager;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.model.IstioResources;
import com.alibaba.nacos.istio.model.IstioService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ResourceSnapshot {
    private static AtomicLong versionSuffix = new AtomicLong(0L);
    private final IstioResources istioResources = new IstioResources(new ConcurrentHashMap<String, IstioService>(16));
    private IstioConfig istioConfig;
    private boolean isCompleted = false;
    private String version;

    public ResourceSnapshot(IstioConfig istioConfig) {
        this.istioConfig = istioConfig;
    }

    public synchronized void initResourceSnapshot(NacosResourceManager manager) {
        if (this.isCompleted) {
            return;
        }
        this.initIstioResources(manager);
        this.generateVersion();
        this.isCompleted = true;
    }

    private void generateVersion() {
        String time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(new Date());
        this.version = time + "/" + versionSuffix.getAndIncrement();
    }

    private void initIstioResources(NacosResourceManager manager) {
        this.istioResources.setIstioServiceMap(manager.services());
    }

    public IstioResources getIstioResources() {
        return this.istioResources;
    }

    public IstioConfig getIstioConfig() {
        return this.istioConfig;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public String getVersion() {
        return this.version;
    }
}

