/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.console.handler.impl.AbstractServerStateHandler;
import com.alibaba.nacos.console.handler.impl.remote.EnabledRemoteHandler;
import com.alibaba.nacos.console.handler.impl.remote.NacosMaintainerClientHolder;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.module.ModuleState;
import com.alibaba.nacos.sys.module.ModuleStateHolder;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
@EnabledRemoteHandler
public class ServerStateRemoteHandler
extends AbstractServerStateHandler {
    private final NacosMaintainerClientHolder clientHolder;

    public ServerStateRemoteHandler(NacosMaintainerClientHolder clientHolder) {
        this.clientHolder = clientHolder;
    }

    @Override
    public Map<String, String> getServerState() throws NacosException {
        Map serverState = this.clientHolder.getNamingMaintainerService().getServerState();
        serverState.put("server_port", EnvUtil.getProperty((String)"nacos.console.port", (String)"8080"));
        for (ModuleState each : ModuleStateHolder.getInstance().getAllModuleStates()) {
            each.getStates().forEach((s, o) -> serverState.put(s, null == o ? null : o.toString()));
        }
        return serverState;
    }
}

